/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.Repository;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.benchmark.ReadDeepTreeTest;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.security.SecurityProviderImpl;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConfiguration;

public class CugTest
extends ReadDeepTreeTest {
    private final ConfigurationParameters params;
    private final boolean reverseOrder;

    protected CugTest(boolean runAsAdmin, int itemsToRead, boolean singleSession, @Nonnull List<String> supportedPaths, boolean reverseOrder) {
        super(runAsAdmin, itemsToRead, false, singleSession);
        this.params = ConfigurationParameters.of("org.apache.jackrabbit.oak.authorization", (Object)ConfigurationParameters.of("cugSupportedPaths", supportedPaths.toArray(new String[supportedPaths.size()]), "cugEnabled", (Object)true));
        this.reverseOrder = reverseOrder;
    }

    @Override
    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        if (fixture instanceof OakRepositoryFixture) {
            return ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                @Override
                public Jcr customize(Oak oak) {
                    return new Jcr(oak).with(CugTest.this.createSecurityProvider());
                }
            });
        }
        throw new IllegalArgumentException("Fixture " + fixture + " not supported for this benchmark.");
    }

    @Override
    protected String getImportFileName() {
        return "deepTree_everyone.xml";
    }

    @Override
    protected String getTestNodeName() {
        return "CugTest";
    }

    protected SecurityProvider createSecurityProvider() {
        return new TmpSecurityProvider(this.params, this.reverseOrder);
    }

    private static final class TmpSecurityProvider
    extends SecurityProviderImpl {
        private TmpSecurityProvider(@Nonnull ConfigurationParameters params, boolean reverseOrder) {
            super(params);
            AuthorizationConfiguration authorizationConfiguration = this.getConfiguration(AuthorizationConfiguration.class);
            AuthorizationConfiguration defaultAuthorization = (AuthorizationConfiguration)Preconditions.checkNotNull(((CompositeAuthorizationConfiguration)authorizationConfiguration).getDefaultConfig());
            if (reverseOrder) {
                this.bindAuthorizationConfiguration(defaultAuthorization);
                this.bindAuthorizationConfiguration(new CugConfiguration(this));
            } else {
                this.bindAuthorizationConfiguration(new CugConfiguration(this));
                this.bindAuthorizationConfiguration(defaultAuthorization);
            }
        }
    }
}

