/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.util.Text;

public class FindAuthorizableWithScopeTest
extends AbstractTest {
    private static final String GROUP_ID = "testGroup";
    private final long numberOfUsers;
    private final boolean setScope;
    private Session adminSession;
    private UserManager userMgr;

    public FindAuthorizableWithScopeTest(long numberOfUsers, boolean setScope) {
        this.numberOfUsers = numberOfUsers;
        this.setScope = setScope;
    }

    @Override
    protected void beforeSuite() throws Exception {
        this.adminSession = this.loginWriter();
        this.userMgr = ((JackrabbitSession)this.adminSession).getUserManager();
        Group gr = this.userMgr.createGroup(GROUP_ID, new PrincipalImpl(GROUP_ID), "test");
        int i = 0;
        while ((long)i < this.numberOfUsers) {
            User u = this.userMgr.createUser("testUser" + i, null, new PrincipalImpl("testUser" + i), "test");
            gr.addMember(u);
            ++i;
        }
        this.adminSession.save();
    }

    @Override
    protected void afterSuite() throws Exception {
        Authorizable u1;
        Authorizable gr = this.userMgr.getAuthorizable(GROUP_ID);
        if (gr != null) {
            Node n = this.adminSession.getNode(Text.getRelativeParent(gr.getPath(), 1));
            n.remove();
        }
        if ((u1 = this.userMgr.getAuthorizable("testUser0")) != null) {
            Node n = this.adminSession.getNode(Text.getRelativeParent(u1.getPath(), 1));
            n.remove();
        }
        this.adminSession.save();
    }

    @Override
    protected void runTest() throws Exception {
        Iterator<Authorizable> result = this.userMgr.findAuthorizables(this.createQuery());
        while (result.hasNext()) {
            result.next();
        }
    }

    private Query createQuery() {
        if (this.setScope) {
            return new Query(){

                @Override
                public <T> void build(QueryBuilder<T> builder) {
                    builder.nameMatches("testUser");
                    builder.setScope(FindAuthorizableWithScopeTest.GROUP_ID, true);
                }
            };
        }
        return new Query(){

            @Override
            public <T> void build(QueryBuilder<T> builder) {
                builder.nameMatches("testUser");
            }
        };
    }
}

