/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.security.Principal;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;

public class FlatTreeWithAceForSamePrincipalTest
extends AbstractTest {
    private static final String TEST_USER_ID = "test" + TEST_ID;
    private static final String ROOT_NODE_NAME = "test" + TEST_ID;
    private static final String ROOT_PATH = "/" + ROOT_NODE_NAME;
    private UserManager userManager;
    private Session admin;
    private Session reader;

    @Override
    protected void beforeSuite() throws Exception {
        long start = System.currentTimeMillis();
        this.admin = this.loginWriter();
        this.userManager = ((JackrabbitSession)this.admin).getUserManager();
        Principal userPrincipal = this.userManager.createUser(TEST_USER_ID, TEST_USER_ID).getPrincipal();
        AccessControlManager acm = this.admin.getAccessControlManager();
        JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList(acm, "/");
        acl.addEntry(userPrincipal, AccessControlUtils.privilegesFromNames(acm, "jcr:read"), true);
        acm.setPolicy("/", acl);
        Node a = this.admin.getRootNode().addNode(ROOT_NODE_NAME, "nt:folder");
        for (int i = 1; i < 10000; ++i) {
            a.addNode("node" + i, "nt:folder");
            acl = AccessControlUtils.getAccessControlList(acm, ROOT_PATH + "/node" + i);
            acl.addEntry(userPrincipal, AccessControlUtils.privilegesFromNames(acm, "jcr:read"), true);
            acm.setPolicy(ROOT_PATH + "/node" + i, acl);
        }
        this.admin.save();
        this.reader = this.login(new SimpleCredentials(TEST_USER_ID, TEST_USER_ID.toCharArray()));
        long end = System.currentTimeMillis();
        System.out.println("setup time " + (end - start));
    }

    @Override
    protected void runTest() throws Exception {
        Node n = this.reader.getNode(ROOT_PATH);
        for (int i = 1; i < 10000; ++i) {
            n.getNode("node" + i);
        }
    }

    @Override
    protected void afterSuite() throws Exception {
        Node root = this.admin.getRootNode();
        if (root.hasNode(ROOT_NODE_NAME)) {
            root.getNode(ROOT_NODE_NAME).remove();
        }
        if (this.userManager != null) {
            this.userManager.getAuthorizable(TEST_USER_ID).remove();
        }
        this.admin.save();
    }
}

