/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.wikipedia.WikipediaImport;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneInitializerHelper;

public class FullTextSearchTest
extends AbstractTest<TestContext> {
    private static final Pattern WORD_PATTERN = Pattern.compile("\\p{LD}{3,}");
    private int maxSampleSize = 100;
    private final boolean disableCopyOnRead = Boolean.getBoolean("disableCopyOnRead");
    private final WikipediaImport importer;
    private final Set<String> sampleSet = Sets.newHashSet();
    private final Random random = new Random(42L);
    private int count = 0;
    private int maxRowsToFetch = Integer.getInteger("maxRowsToFetch", 100);
    private TestContext defaultContext;
    protected Boolean storageEnabled;
    private ExecutorService executorService = Executors.newFixedThreadPool(2);
    private File indexCopierDir;

    public FullTextSearchTest(File dump, boolean flat, boolean doReport, Boolean storageEnabled) {
        this.importer = new WikipediaImport(dump, flat, doReport){

            @Override
            protected void pageAdded(String title, String text) {
                FullTextSearchTest.this.count++;
                if (FullTextSearchTest.this.count % 100 == 0 && FullTextSearchTest.this.sampleSet.size() < FullTextSearchTest.this.maxSampleSize && text != null) {
                    ArrayList<String> words = Lists.newArrayList();
                    Matcher matcher = WORD_PATTERN.matcher(text);
                    while (matcher.find()) {
                        words.add(matcher.group());
                    }
                    if (!words.isEmpty()) {
                        FullTextSearchTest.this.sampleSet.add(words.get(words.size() / 2));
                    }
                }
            }
        };
        this.storageEnabled = storageEnabled;
        this.indexCopierDir = this.createTemporaryFolder(null);
    }

    @Override
    public void beforeSuite() throws Exception {
        this.random.setSeed(42L);
        this.sampleSet.clear();
        this.count = 0;
        this.importer.importWikipedia(this.loginWriter());
        Thread.sleep(10L);
        this.defaultContext = new TestContext();
    }

    @Override
    protected void afterSuite() throws Exception {
        this.executorService.shutdown();
        this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
        FileUtils.deleteDirectory(this.indexCopierDir);
    }

    @Override
    protected TestContext prepareThreadExecutionContext() {
        return new TestContext();
    }

    @Override
    protected void runTest() throws Exception {
        this.runTest(this.defaultContext);
    }

    @Override
    protected void runTest(TestContext ec) throws Exception {
        QueryManager qm = ec.session.getWorkspace().getQueryManager();
        for (String word : ec.words) {
            Query q = qm.createQuery("//*[jcr:contains(@text, '" + word + "')] ", "xpath");
            QueryResult r = q.execute();
            RowIterator it = r.getRows();
            for (int rows = 0; it.hasNext() && rows < this.maxRowsToFetch; ++rows) {
                Node n = it.nextRow().getNode();
                ec.hash += n.getProperty("text").getString().hashCode();
                ec.hash += n.getProperty("title").getString().hashCode();
            }
        }
    }

    private String[] getRandomWords() {
        ArrayList<String> samples = Lists.newArrayList(this.sampleSet);
        String[] words = new String[100];
        for (int i = 0; i < words.length; ++i) {
            words[i] = (String)samples.get(this.random.nextInt(samples.size()));
        }
        return words;
    }

    @Override
    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        if (fixture instanceof OakRepositoryFixture) {
            return ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                @Override
                public Jcr customize(Oak oak) {
                    LuceneIndexProvider provider = FullTextSearchTest.this.createLuceneIndexProvider();
                    oak.with(provider).with(provider).with(new LuceneIndexEditorProvider()).with(new LuceneInitializerHelper("luceneGlobal", FullTextSearchTest.this.storageEnabled));
                    return new Jcr(oak);
                }
            });
        }
        return super.createRepository(fixture);
    }

    private LuceneIndexProvider createLuceneIndexProvider() {
        if (!this.disableCopyOnRead) {
            try {
                IndexCopier copier = new IndexCopier(this.executorService, this.indexCopierDir, true);
                return new LuceneIndexProvider(copier);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new LuceneIndexProvider();
    }

    private File createTemporaryFolder(File parentFolder) {
        File createdFolder = null;
        try {
            createdFolder = File.createTempFile("oak", "", parentFolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        createdFolder.delete();
        createdFolder.mkdir();
        return createdFolder;
    }

    class TestContext {
        final Session session;
        final String[] words;
        int hash;

        TestContext() {
            this.session = FullTextSearchTest.this.loginWriter();
            this.words = FullTextSearchTest.this.getRandomWords();
            this.hash = 0;
        }
    }
}

