/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Nonnull;
import javax.jcr.Repository;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.benchmark.FullTextSearchTest;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.DefaultSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.RemoteSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.NodeStateSolrServersObserver;
import org.apache.jackrabbit.oak.plugins.index.solr.index.SolrIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.EmbeddedSolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.util.SolrIndexInitializer;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextSolrSearchTest
extends FullTextSearchTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SolrServerProvider serverProvider;
    private String server;

    public FullTextSolrSearchTest(File dump, boolean flat, boolean doReport, Boolean storageEnabled, String server) {
        super(dump, flat, doReport, storageEnabled);
        this.server = server;
    }

    @Override
    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        this.initializeProvider();
        if (fixture instanceof OakRepositoryFixture) {
            return ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                @Override
                public Jcr customize(Oak oak) {
                    OakSolrConfigurationProvider configurationProvider = new OakSolrConfigurationProvider(){

                        @Override
                        @Nonnull
                        public OakSolrConfiguration getConfiguration() {
                            return new DefaultSolrConfiguration(){

                                @Override
                                public int getRows() {
                                    return 50;
                                }
                            };
                        }
                    };
                    oak.with(new SolrQueryIndexProvider(FullTextSolrSearchTest.this.serverProvider, configurationProvider)).with(new NodeStateSolrServersObserver()).with(new SolrIndexEditorProvider(FullTextSolrSearchTest.this.serverProvider, configurationProvider)).with(new SolrIndexInitializer(false));
                    return new Jcr(oak);
                }
            });
        }
        return super.createRepository(fixture);
    }

    private void initializeProvider() throws Exception {
        if (this.server == null || "default".equals(this.server)) {
            this.log.info("spawning Solr locally");
            this.serverProvider = this.createEmbeddedSolrServerProvider(true);
        } else if (this.server != null && "embedded".equals(this.server)) {
            this.log.info("using embedded Solr");
            this.serverProvider = this.createEmbeddedSolrServerProvider(false);
        } else if (this.server != null && (this.server.startsWith("http") || this.server.matches("\\w+\\:\\d{3,5}"))) {
            this.log.info("using remote Solr {}", (Object)this.server);
            RemoteSolrServerConfiguration remoteSolrServerConfiguration = new RemoteSolrServerConfiguration(this.server, "oak", 2, 2, null, this.server);
            this.serverProvider = remoteSolrServerConfiguration.getProvider();
        } else {
            throw new IllegalArgumentException("server parameter value must be either 'embedded', 'default', an URL or an host:port String");
        }
    }

    private EmbeddedSolrServerProvider createEmbeddedSolrServerProvider(boolean http) throws Exception {
        String tempDirectoryPath = FileUtils.getTempDirectoryPath();
        File solrHome = new File(tempDirectoryPath, "solr" + System.nanoTime());
        EmbeddedSolrServerConfiguration embeddedSolrServerConfiguration = new EmbeddedSolrServerConfiguration(solrHome.getAbsolutePath(), "oak");
        if (http) {
            embeddedSolrServerConfiguration = embeddedSolrServerConfiguration.withHttpConfiguration("/solr", 8983);
        }
        EmbeddedSolrServerProvider embeddedSolrServerProvider = (EmbeddedSolrServerProvider)embeddedSolrServerConfiguration.getProvider();
        SolrServer solrServer = embeddedSolrServerProvider.getSolrServer();
        if (this.storageEnabled != null && !this.storageEnabled.booleanValue()) {
            File schemaXML = new File(solrHome.getAbsolutePath() + "/oak/conf", "schema.xml");
            InputStream inputStream = this.getClass().getResourceAsStream("/solr/oak/conf/schema.xml");
            String schemaString = IOUtils.toString(inputStream).replace("<dynamicField name=\"*\" type=\"text_general\" indexed=\"true\" stored=\"true\" multiValued=\"true\"/>", "<dynamicField name=\"*\" type=\"text_general\" indexed=\"true\" stored=\"false\" multiValued=\"true\"/>");
            FileOutputStream fileOutputStream = new FileOutputStream(schemaXML);
            IOUtils.copy((Reader)new StringReader(schemaString), (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            ((EmbeddedSolrServer)solrServer).getCoreContainer().reload("oak");
        }
        return embeddedSolrServerProvider;
    }

    @Override
    protected void afterSuite() throws Exception {
        SolrServer solrServer = this.serverProvider.getSolrServer();
        if (solrServer != null) {
            solrServer.shutdown();
        }
    }
}

