/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;

public class GetAuthorizableByIdTest
extends AbstractTest {
    private final int numberOfUsers;
    private final boolean flat;
    private final List<String> ids = new ArrayList<String>();

    public GetAuthorizableByIdTest(int numberOfUsers, boolean flatStructure) {
        this.numberOfUsers = numberOfUsers;
        this.flat = flatStructure;
    }

    @Override
    protected void beforeSuite() throws Exception {
        Session s = this.loginWriter();
        UserManager userManager = ((JackrabbitSession)s).getUserManager();
        for (int i = 0; i < this.numberOfUsers; ++i) {
            String id = this.flat ? "user" + i : UUID.randomUUID().toString();
            User user = userManager.createUser(id, id);
            this.ids.add(id);
        }
        s.save();
        System.out.println("Setup " + this.numberOfUsers + " users");
    }

    @Override
    protected void afterSuite() throws Exception {
        Session session = this.loginWriter();
        session.getNode("/rep:security/rep:authorizables/rep:users/u").remove();
        session.save();
    }

    @Override
    protected void runTest() throws Exception {
        Session s = this.loginWriter();
        UserManager userManager = ((JackrabbitSession)s).getUserManager();
        for (int i = 0; i < 1000; ++i) {
            Authorizable a = userManager.getAuthorizable(this.getUserId());
        }
    }

    protected String getUserId() {
        return this.ids.get((int)Math.floor((double)this.numberOfUsers * Math.random()));
    }
}

