/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.util.Text;

public class GetGroupPrincipalsTest
extends AbstractTest {
    private static final String USER = "user";
    private static final String GROUP = "group";
    private final int numberOfGroups;
    private final boolean nestedGroups;
    private String principalName;
    private Session session;

    public GetGroupPrincipalsTest(int numberOfGroups, boolean nestedGroups) {
        this.numberOfGroups = numberOfGroups;
        this.nestedGroups = nestedGroups;
    }

    @Override
    public void setUp(Repository repository, Credentials credentials) throws Exception {
        super.setUp(repository, credentials);
        this.session = this.loginAdministrative();
        UserManager userManager = ((JackrabbitSession)this.session).getUserManager();
        Authorizable user = userManager.getAuthorizable(USER);
        if (user == null) {
            user = userManager.createUser(USER, USER);
            this.principalName = user.getPrincipal().getName();
        }
        Group gr = userManager.createGroup(new PrincipalImpl(GROUP), "test");
        gr.addMember(user);
        for (int i = 1; i < this.numberOfGroups; ++i) {
            Group g = userManager.createGroup(new PrincipalImpl(GROUP + i), "test");
            if (!this.nestedGroups) {
                g.addMember(user);
            } else {
                g.addMember(gr);
            }
            gr = g;
        }
        this.session.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            UserManager userMgr = ((JackrabbitSession)this.session).getUserManager();
            Authorizable authorizable = userMgr.getAuthorizable(USER);
            if (authorizable != null) {
                authorizable.remove();
            }
            if ((authorizable = userMgr.getAuthorizable(GROUP)) != null) {
                Node n = this.session.getNode(Text.getRelativeParent(authorizable.getPath(), 1));
                n.remove();
            }
            this.session.save();
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    public void runTest() throws Exception {
        PrincipalManager principalManager = ((JackrabbitSession)this.session).getPrincipalManager();
        for (int i = 0; i < 1000; ++i) {
            Principal p = principalManager.getPrincipal(this.principalName);
            PrincipalIterator principals = principalManager.getGroupMembership(p);
        }
    }
}

