/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.security.Principal;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.Benchmark;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;

public abstract class GetNodeTest
extends AbstractTest {
    private final String name;
    private Node testRoot;

    public static Benchmark withAdmin() {
        return new GetNodeTest("GetNodeWithAdmin"){

            @Override
            protected Session login() {
                return this.loginWriter();
            }
        };
    }

    public static Benchmark withAnonymous() {
        return new GetNodeTest("GetNodeWithAnonymous"){

            @Override
            protected Session login() {
                return this.loginAnonymous();
            }
        };
    }

    protected GetNodeTest(String name) {
        this.name = name;
    }

    protected abstract Session login();

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    protected void beforeSuite() throws Exception {
        Session session = this.loginWriter();
        this.testRoot = session.getRootNode().addNode(this.getClass().getSimpleName() + TEST_ID, "nt:unstructured");
        this.testRoot.addNode("node1").addNode("node2");
        AccessControlUtils.addAccessControlEntry(session, this.testRoot.getPath(), (Principal)EveryonePrincipal.getInstance(), new String[]{"{http://www.jcp.org/jcr/1.0}read"}, true);
        session.save();
        this.testRoot = this.login().getNode(this.testRoot.getPath());
        session.logout();
    }

    @Override
    protected void runTest() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            this.testRoot.getNode("node1").getNode("node2");
            this.testRoot.getNode("node1/node2");
            this.testRoot.hasNode("node-does-not-exist");
        }
    }

    @Override
    protected void afterSuite() throws Exception {
        Session session = this.loginWriter();
        session.getNode(this.testRoot.getPath()).remove();
        this.testRoot.getSession().logout();
        session.save();
        session.logout();
    }
}

