/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.security.Principal;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;

public class GetPoliciesTest
extends AbstractTest {
    private Session session;
    private Node testRoot;
    private String path;
    private AccessControlManager acm;

    @Override
    protected void beforeSuite() throws Exception {
        this.session = this.loginWriter();
        this.testRoot = this.session.getRootNode().addNode(this.getClass().getSimpleName() + TEST_ID, "nt:unstructured");
        Node n = this.testRoot.addNode("node1");
        this.path = n.getPath();
        AccessControlUtils.addAccessControlEntry(this.session, n.getPath(), (Principal)EveryonePrincipal.getInstance(), new String[]{"{http://www.jcp.org/jcr/1.0}read"}, true);
        this.session.save();
        this.testRoot = this.loginWriter().getNode(this.testRoot.getPath());
        this.acm = this.testRoot.getSession().getAccessControlManager();
    }

    @Override
    protected void runTest() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            this.acm.getPolicies(this.path);
        }
    }

    @Override
    protected void afterSuite() throws Exception {
        this.testRoot.remove();
        this.session.save();
        this.session.logout();
    }
}

