/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.collect.ImmutableSet;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.oak.benchmark.AbstractLoginTest;
import org.apache.jackrabbit.oak.jcr.repository.RepositoryImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.SystemSubject;

public class LoginSystemTest
extends AbstractLoginTest {
    private Subject subject;

    @Override
    public void setUp(Repository repository, Credentials credentials) throws Exception {
        super.setUp(repository, credentials);
        this.subject = repository instanceof RepositoryImpl ? SystemSubject.INSTANCE : new Subject(true, ImmutableSet.of(new SystemPrincipal()), Collections.emptySet(), Collections.emptySet());
    }

    @Override
    public void runTest() throws RepositoryException {
        for (int i = 0; i < 1000; ++i) {
            try {
                Subject.doAsPrivileged(this.subject, new PrivilegedExceptionAction<Session>(){

                    @Override
                    public Session run() throws Exception {
                        return LoginSystemTest.this.getRepository().login(null, null);
                    }
                }, null).logout();
                continue;
            }
            catch (PrivilegedActionException e) {
                throw new RepositoryException("failed to retrieve admin session.", e);
            }
        }
    }
}

