/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.benchmark.AbstractLoginTest;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.util.Text;

public class LoginWithMembersTest
extends AbstractLoginTest {
    private static final String GROUP = "group";
    private final int numberOfMembers;

    public LoginWithMembersTest(boolean runWithToken, int noIterations, int numberOfMembers, long expiration) {
        super("user", runWithToken, noIterations, expiration);
        this.numberOfMembers = numberOfMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp(Repository repository, Credentials credentials) throws Exception {
        super.setUp(repository, credentials);
        Session s = this.loginAdministrative();
        try {
            UserManager userManager = ((JackrabbitSession)s).getUserManager();
            Authorizable user = userManager.getAuthorizable("user");
            Group gr = userManager.createGroup(new PrincipalImpl(GROUP), "test");
            gr.addMember(user);
            for (int i = 1; i < this.numberOfMembers; ++i) {
                Group g = userManager.createGroup(new PrincipalImpl(GROUP + i), "test");
                gr.addMember(g);
            }
        }
        finally {
            s.save();
            s.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            Session s = this.loginAdministrative();
            Authorizable authorizable = ((JackrabbitSession)s).getUserManager().getAuthorizable(GROUP);
            if (authorizable != null) {
                Node n = s.getNode(Text.getRelativeParent(authorizable.getPath(), 1));
                n.remove();
            }
            s.save();
            s.logout();
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    public void runTest() throws RepositoryException {
        Repository repository = this.getRepository();
        for (int i = 0; i < 1000; ++i) {
            repository.login(this.getCredentials()).logout();
        }
    }
}

