/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.wikipedia.WikipediaImport;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneInitializerHelper;
import org.apache.jackrabbit.oak.plugins.tree.TreeFactory;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LucenePropertyFullTextTest
extends AbstractTest<TestContext> {
    private static final Logger LOG = LoggerFactory.getLogger(LucenePropertyFullTextTest.class);
    private WikipediaImport importer;
    private Thread asyncImporter;
    private boolean benchmarkCompleted;
    private boolean importerCompleted;
    Boolean storageEnabled;
    String currentFixture;
    String currentTest;
    private AtomicReference<String> lastTitle = new AtomicReference();

    public LucenePropertyFullTextTest(File dump, boolean flat, boolean doReport, Boolean storageEnabled) {
        this.importer = new WikipediaImport(dump, flat, doReport){

            @Override
            protected void pageAdded(String title, String text) {
                LOG.trace("Setting title: {}", (Object)title);
                LucenePropertyFullTextTest.this.lastTitle.set(title);
            }
        };
        this.storageEnabled = storageEnabled;
        this.currentTest = this.getClass().getSimpleName();
    }

    @Override
    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        if (fixture instanceof OakRepositoryFixture) {
            this.currentFixture = fixture.toString();
            return ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                @Override
                public Jcr customize(Oak oak) {
                    LuceneIndexProvider provider = new LuceneIndexProvider();
                    oak.with(provider).with(provider).with(new LuceneIndexEditorProvider()).with(new LuceneInitializerHelper("luceneGlobal", LucenePropertyFullTextTest.this.storageEnabled).async()).with(new LucenePropertyInitialiser("luceneTitle", ImmutableSet.of("title"))).withAsyncIndexing("async", 5L);
                    return new Jcr(oak);
                }
            });
        }
        return super.createRepository(fixture);
    }

    @Override
    protected void beforeSuite() throws Exception {
        LOG.debug("beforeSuite() - {} - {}", (Object)this.currentFixture, (Object)this.currentTest);
        this.benchmarkCompleted = false;
        this.importerCompleted = false;
        this.asyncImporter = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    LucenePropertyFullTextTest.this.importer.importWikipedia(LucenePropertyFullTextTest.this.loginWriter());
                }
                catch (Exception e) {
                    LOG.error("Error while importing the dump. Trying to halt everything.", e);
                    LucenePropertyFullTextTest.this.importerCompleted = true;
                }
                finally {
                    if (!LucenePropertyFullTextTest.this.benchmarkCompleted) {
                        LucenePropertyFullTextTest.this.importerCompleted = true;
                        LucenePropertyFullTextTest.this.issueHaltRequest("Wikipedia import completed.");
                    }
                }
            }
        });
        this.asyncImporter.start();
        TimeUnit.SECONDS.sleep(10L);
    }

    @Override
    protected void afterSuite() throws Exception {
        LOG.debug("afterSuite() - {} - {}", (Object)this.currentFixture, (Object)this.currentTest);
        this.asyncImporter.join();
    }

    @Override
    protected void runTest() throws Exception {
        if (this.lastTitle.get() == null) {
            return;
        }
        this.runTest(new TestContext(this.lastTitle.get()));
    }

    @Override
    protected void runTest(TestContext ec) throws Exception {
        long sleptSoFar;
        if (this.importerCompleted) {
            return;
        }
        long maxWait = TimeUnit.MINUTES.toMillis(5L);
        long waitUnit = 50L;
        for (sleptSoFar = 0L; !this.performQuery(ec) && sleptSoFar < maxWait; sleptSoFar += 50L) {
            LOG.trace("title '{}' not found. Waiting and retry. sleptSoFar: {}ms", (Object)ec.title, (Object)sleptSoFar);
            TimeUnit.MILLISECONDS.sleep(50L);
        }
        if (sleptSoFar < maxWait) {
            LOG.info("{} - {} - title '{}' found with a wait/try of {}ms", this.currentFixture, this.currentTest, ec.title, sleptSoFar);
        } else {
            LOG.warn("{} - {} - title '{}' timed out with a way/try of {}ms.", this.currentFixture, this.currentTest, ec.title, sleptSoFar);
        }
    }

    private boolean performQuery(@Nonnull TestContext ec) throws RepositoryException {
        QueryManager qm = ec.session.getWorkspace().getQueryManager();
        ValueFactory vf = ec.session.getValueFactory();
        Query q = qm.createQuery("SELECT * FROM [nt:base] WHERE [title] = $title", "JCR-SQL2");
        q.bindValue("title", vf.createValue(ec.title));
        LOG.trace("statement: {} - title: {}", (Object)q.getStatement(), (Object)ec.title);
        RowIterator rows = q.execute().getRows();
        if (rows.hasNext()) {
            rows.nextRow().getPath();
            return true;
        }
        return false;
    }

    @Override
    protected void issueHaltChildThreads() {
        if (!this.importerCompleted) {
            LOG.info("benchmark completed. Issuing an halt for the importer");
            this.benchmarkCompleted = true;
            this.importer.issueHaltImport();
        }
    }

    static class LucenePropertyInitialiser
    implements RepositoryInitializer {
        private String name;
        private Set<String> properties;

        public LucenePropertyInitialiser(@Nonnull String name, @Nonnull Set<String> properties) {
            this.name = Preconditions.checkNotNull(name);
            this.properties = Preconditions.checkNotNull(properties);
        }

        private boolean isAlreadyThere(@Nonnull NodeBuilder root) {
            return Preconditions.checkNotNull(root).hasChildNode("oak:index") && root.getChildNode("oak:index").hasChildNode(this.name);
        }

        @Override
        public void initialize(NodeBuilder builder) {
            if (!this.isAlreadyThere(builder)) {
                Tree t = TreeFactory.createTree(builder.child("oak:index"));
                t = t.addChild(this.name);
                t.setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME);
                t.setProperty("compatVersion", 2L, Type.LONG);
                t.setProperty("type", "lucene", Type.STRING);
                t.setProperty("async", "async", Type.STRING);
                t.setProperty("reindex", true);
                t = t.addChild("indexRules");
                t.setOrderableChildren(true);
                t.setProperty("jcr:primaryType", "nt:unstructured", Type.NAME);
                t = t.addChild("nt:base");
                Tree propnode = t.addChild("properties");
                propnode.setOrderableChildren(true);
                propnode.setProperty("jcr:primaryType", "nt:unstructured", Type.NAME);
                for (String p : this.properties) {
                    Tree t1 = propnode.addChild(PathUtils.getName(p));
                    t1.setProperty("propertyIndex", true, Type.BOOLEAN);
                    t1.setProperty("name", p);
                }
            }
        }
    }

    class TestContext {
        final Session session;
        final String title;

        public TestContext(String title) {
            this.session = LucenePropertyFullTextTest.this.loginWriter();
            this.title = Preconditions.checkNotNull(title);
        }
    }
}

