/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.security.SecurityProviderImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.SystemSubject;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.util.Text;

public class ManyGroupMembersTest
extends AbstractTest {
    private final Random random = new Random();
    private static final String REL_TEST_PATH = "testPath";
    private static final String USER = "user";
    private static final String GROUP = "group";
    private static final int GROUP_CNT = 100;
    static final int DEFAULT_BATCH_SIZE = 1;
    private final int numberOfMembers;
    private final int batchSize;
    private final String importBehavior;

    public ManyGroupMembersTest(int numberOfMembers, int batchSize, @Nonnull String importBehavior) {
        this.numberOfMembers = numberOfMembers;
        this.batchSize = batchSize;
        this.importBehavior = importBehavior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp(Repository repository, Credentials credentials) throws Exception {
        super.setUp(repository, credentials);
        Session s = this.loginAdministrative();
        try {
            int i;
            UserManager userManager = ((JackrabbitSession)s).getUserManager();
            for (i = 0; i <= 100; ++i) {
                userManager.createGroup(new PrincipalImpl(GROUP + i), REL_TEST_PATH);
            }
            if (!"besteffort".equals(this.importBehavior)) {
                for (i = 0; i <= this.numberOfMembers; ++i) {
                    String id = USER + i;
                    userManager.createUser(id, null, new PrincipalImpl(id), REL_TEST_PATH);
                }
            }
        }
        finally {
            s.save();
            s.logout();
        }
        System.out.println("setup done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            Node n;
            Session s = this.loginAdministrative();
            Authorizable authorizable = ((JackrabbitSession)s).getUserManager().getAuthorizable("group0");
            if (authorizable != null) {
                n = s.getNode(Text.getRelativeParent(authorizable.getPath(), 1));
                n.remove();
            }
            if (!"besteffort".equals(this.importBehavior) && (authorizable = ((JackrabbitSession)s).getUserManager().getAuthorizable("user0")) != null) {
                n = s.getNode(Text.getRelativeParent(authorizable.getPath(), 1));
                n.remove();
            }
            s.save();
            s.logout();
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        if (fixture instanceof OakRepositoryFixture) {
            return ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                @Override
                public Jcr customize(Oak oak) {
                    SecurityProviderImpl sp = new SecurityProviderImpl(ConfigurationParameters.of("org.apache.jackrabbit.oak.user", (Object)ConfigurationParameters.of("importBehavior", ManyGroupMembersTest.this.importBehavior)));
                    return new Jcr(oak).with(sp);
                }
            });
        }
        return super.createRepository(fixture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTest() throws Exception {
        Session s = null;
        try {
            s = Subject.doAsPrivileged(SystemSubject.INSTANCE, new PrivilegedExceptionAction<Session>(){

                @Override
                public Session run() throws Exception {
                    return ManyGroupMembersTest.this.getRepository().login(null, null);
                }
            }, null);
            UserManager userManager = ((JackrabbitSession)s).getUserManager();
            String groupId = GROUP + this.random.nextInt(100);
            Group g = userManager.getAuthorizable(groupId, Group.class);
            for (int i = 0; i <= this.numberOfMembers; ++i) {
                if (this.batchSize <= 1) {
                    g.addMembers(USER + i);
                } else {
                    ArrayList<String> ids = new ArrayList<String>(this.batchSize);
                    for (int j = 0; j < this.batchSize && i <= this.numberOfMembers; ++i, ++j) {
                        ids.add(USER + i);
                    }
                    g.addMembers(ids.toArray(new String[ids.size()]));
                }
                s.save();
            }
        }
        catch (RepositoryException e) {
            System.out.println(e.getMessage());
            if (s.hasPendingChanges()) {
                s.refresh(false);
            }
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }
}

