/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.oak.benchmark.Benchmark;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;

public class ManyNodes
extends Benchmark {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Iterable<RepositoryFixture> fixtures) {
        for (RepositoryFixture fixture : fixtures) {
            System.out.println("ManyNodes test: " + fixture);
            if (fixture.isAvailable(1)) {
                try {
                    Repository[] cluster = fixture.setUpCluster(1);
                    try {
                        Session session = cluster[0].login(new SimpleCredentials("admin", "admin".toCharArray()));
                        try {
                            this.addManyNodes(session);
                        }
                        finally {
                            session.logout();
                        }
                    }
                    finally {
                        fixture.tearDownCluster();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println("- not available, skipping");
        }
    }

    private void addManyNodes(Session session) throws RepositoryException {
        Node root = session.getRootNode().addNode("testRoot");
        session.save();
        int total = 0;
        long time = System.currentTimeMillis();
        for (int k = 0; k < 1000; ++k) {
            Node nk = root.addNode("test" + k, "nt:folder");
            for (int j = 0; j < 100; ++j) {
                Node nj = nk.addNode("test" + j, "nt:folder");
                for (int i = 0; i < 100; ++i) {
                    nj.addNode("child" + i, "nt:folder");
                    ++total;
                }
                session.save();
                if (total % 10000 != 0) continue;
                long now = System.currentTimeMillis();
                System.out.println(total + " nodes in " + (now - time) + " ms");
                time = now;
            }
        }
    }
}

