/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.security.Principal;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.benchmark.ReadDeepTreeTest;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;

public class ManyUserReadTest
extends ReadDeepTreeTest {
    private final int numberOfUsers = 1000;
    private final int numberOfMembers = 10;
    private final boolean randomUser;

    protected ManyUserReadTest(boolean runAsAdmin, int itemsToRead, boolean doReport, boolean randomUser) {
        super(runAsAdmin, itemsToRead, doReport, !randomUser);
        this.randomUser = randomUser;
    }

    @Override
    protected void createDeepTree() throws Exception {
        int i;
        super.createDeepTree();
        UserManager userManager = ((JackrabbitSession)this.adminSession).getUserManager();
        for (i = 0; i < 1000; ++i) {
            User user = userManager.createUser("user" + i, "user" + i);
            AccessControlUtils.addAccessControlEntry(this.adminSession, user.getPath(), user.getPrincipal(), new String[]{"{http://www.jcp.org/jcr/1.0}all"}, true);
            Node userNode = this.adminSession.getNode(user.getPath());
            Node n = userNode.addNode("public");
            n.setProperty("prop", "value");
            String path = n.getPath();
            AccessControlUtils.addAccessControlEntry(this.adminSession, path, (Principal)EveryonePrincipal.getInstance(), new String[]{"{http://www.jcp.org/jcr/1.0}read"}, true);
            this.allPaths.add(path);
            this.allPaths.add(path + "/prop");
            Group g = userManager.createGroup("group" + i);
            AccessControlUtils.addAccessControlEntry(this.adminSession, g.getPath(), g.getPrincipal(), new String[]{"{http://www.jcp.org/jcr/1.0}read"}, true);
            n = userNode.addNode("semi");
            n.setProperty("prop", "value");
            path = n.getPath();
            AccessControlUtils.addAccessControlEntry(this.adminSession, path, g.getPrincipal(), new String[]{"{http://www.jcp.org/jcr/1.0}read"}, true);
            this.allPaths.add(path);
            this.allPaths.add(path + "/prop");
            userNode.addNode("private").setProperty("prop", "value");
            this.adminSession.save();
        }
        System.out.println("Setup 1000 users");
        for (i = 0; i < 1000; ++i) {
            Group g = (Group)userManager.getAuthorizable("group" + i);
            for (int j = 0; j < 10; ++j) {
                g.addMember(userManager.getAuthorizable("user" + this.getIndex()));
            }
            this.adminSession.save();
        }
        System.out.println("Setup group membership (10 members per group)");
        System.out.println("All Paths : " + this.allPaths.size());
        AccessControlUtils.denyAllToEveryone(this.adminSession, "/rep:security/rep:authorizables");
        this.adminSession.save();
    }

    @Override
    protected String getImportFileName() {
        return "deepTree_everyone.xml";
    }

    @Override
    protected Session getTestSession() {
        if (this.runAsAdmin) {
            return this.loginWriter();
        }
        String userId = this.randomUser ? "user" + this.getIndex() : "user1";
        SimpleCredentials sc = new SimpleCredentials(userId, userId.toCharArray());
        return this.login(sc);
    }

    private int getIndex() {
        return (int)Math.floor(1000.0 * Math.random());
    }
}

