/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.Benchmark;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserverMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;

public class ObservationTest
extends Benchmark {
    public static final int EVENT_TYPES = 127;
    private static final int EVENTS_PER_NODE = 2;
    private static final int SAVE_INTERVAL = Integer.getInteger("saveInterval", 100);
    private static final int OUTPUT_RESOLUTION = 100;
    private static final int LISTENER_COUNT = Integer.getInteger("listenerCount", 100);
    private static final int WRITER_COUNT = Integer.getInteger("writerCount", 1);
    private static final String PATH_FILTER = System.getProperty("pathFilter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Iterable<RepositoryFixture> fixtures) {
        for (RepositoryFixture fixture : fixtures) {
            if (!fixture.isAvailable(1)) continue;
            System.out.format("%s: Observation throughput benchmark%n", fixture);
            try {
                final AtomicReference whiteboardRef = new AtomicReference();
                Repository[] cluster = fixture instanceof OakRepositoryFixture ? ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                    @Override
                    public Jcr customize(Oak oak) {
                        whiteboardRef.set(oak.getWhiteboard());
                        return new Jcr(oak);
                    }
                }) : fixture.setUpCluster(1);
                try {
                    this.run(cluster[0], (Whiteboard)whiteboardRef.get());
                }
                finally {
                    fixture.tearDownCluster();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Repository repository, @Nullable Whiteboard whiteboard) throws RepositoryException, ExecutionException, InterruptedException {
        Session session = ObservationTest.createSession(repository);
        long t0 = System.currentTimeMillis();
        try {
            this.observationThroughput(repository, whiteboard);
        }
        finally {
            System.out.println("Time elapsed: " + (System.currentTimeMillis() - t0) + " ms");
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void observationThroughput(final Repository repository, @Nullable Whiteboard whiteboard) throws RepositoryException, InterruptedException, ExecutionException {
        long t = 0L;
        AtomicInteger eventCount = new AtomicInteger();
        final AtomicInteger nodeCount = new AtomicInteger();
        ArrayList<Session> sessions = Lists.newArrayList();
        ArrayList<EventListener> listeners = Lists.newArrayList();
        ArrayList<String> testPaths = Lists.newArrayList();
        Session s = ObservationTest.createSession(repository);
        String path = "/path/to/observation/benchmark-" + AbstractTest.TEST_ID;
        try {
            Node testRoot = JcrUtils.getOrCreateByPath(path, null, s);
            for (int i = 0; i < WRITER_COUNT; ++i) {
                testPaths.add(testRoot.addNode("session-" + i).getPath());
            }
            s.save();
        }
        finally {
            s.logout();
        }
        String pathFilter = PATH_FILTER == null ? path : PATH_FILTER;
        System.out.println("Path filter for event listener: " + pathFilter);
        ExecutorService service = Executors.newFixedThreadPool(WRITER_COUNT);
        try {
            for (int k = 0; k < LISTENER_COUNT; ++k) {
                sessions.add(ObservationTest.createSession(repository));
                listeners.add(new Listener(eventCount));
                ObservationManager obsMgr = ((Session)sessions.get(k)).getWorkspace().getObservationManager();
                obsMgr.addEventListener((EventListener)listeners.get(k), 127, pathFilter, true, null, null, false);
            }
            this.addRootListener(repository, sessions, listeners);
            ArrayList<Future<Object>> createNodes = Lists.newArrayList();
            for (final String p : testPaths) {
                createNodes.add(service.submit(new Callable<Object>(){
                    private final Session session;
                    private int numNodes;
                    {
                        this.session = ObservationTest.createSession(repository);
                        this.numNodes = 0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object call() throws Exception {
                        try {
                            Node testRoot = this.session.getNode(p);
                            this.createChildren(testRoot, 100);
                            for (Node m : JcrUtils.getChildNodes(testRoot)) {
                                this.createChildren(m, 100 / WRITER_COUNT);
                                for (Node n : JcrUtils.getChildNodes(m)) {
                                    this.createChildren(n, 5);
                                }
                            }
                            this.session.save();
                        }
                        finally {
                            this.session.logout();
                        }
                        return null;
                    }

                    private void createChildren(Node node, int count) throws RepositoryException {
                        for (int c = 0; c < count; ++c) {
                            node.addNode("n" + c);
                            nodeCount.incrementAndGet();
                            if (++this.numNodes % SAVE_INTERVAL != 0) continue;
                            node.getSession().save();
                        }
                    }
                }));
            }
            System.out.println("ms      #node   nodes/s #event  event/s event-ratio queue external");
            while (!ObservationTest.isDone(createNodes) || eventCount.get() / LISTENER_COUNT < nodeCount.get() * 2) {
                long t0 = System.currentTimeMillis();
                Thread.sleep(100L);
                int nc = nodeCount.get();
                int ec = eventCount.get() / LISTENER_COUNT;
                int[] ql = ObservationTest.getObservationQueueLength(whiteboard);
                double nps = (double)nc / (double)(t += System.currentTimeMillis() - t0) * 1000.0;
                double eps = (double)ec / (double)t * 1000.0;
                double epn = (double)ec / (double)nc / 2.0;
                System.out.format("%7d %7d %7.1f %7d %7.1f %7.2f %7d %7d%n", t, nc, nps, ec, eps, epn, ql[0], ql[1]);
            }
            ObservationTest.get(createNodes);
        }
        finally {
            for (int k = 0; k < sessions.size(); ++k) {
                ((Session)sessions.get(k)).getWorkspace().getObservationManager().removeEventListener((EventListener)listeners.get(k));
                ((Session)sessions.get(k)).logout();
            }
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    private void addRootListener(Repository repository, List<Session> sessions, List<EventListener> listeners) throws RepositoryException {
        Session s = ObservationTest.createSession(repository);
        sessions.add(s);
        Listener listener = new Listener(new AtomicInteger());
        ObservationManager obsMgr = s.getWorkspace().getObservationManager();
        obsMgr.addEventListener(listener, 127, "/", true, null, null, false);
        listeners.add(listener);
    }

    private static int[] getObservationQueueLength(@Nullable Whiteboard wb) {
        if (wb == null) {
            return new int[]{-1, -1};
        }
        int len = -1;
        int ext = -1;
        for (BackgroundObserverMBean bean : WhiteboardUtils.getServices(wb, BackgroundObserverMBean.class)) {
            len = Math.max(bean.getQueueSize(), len);
            ext = Math.max(bean.getExternalEventCount(), ext);
        }
        return new int[]{len, ext};
    }

    private static boolean isDone(Iterable<Future<Object>> futures) {
        for (Future<Object> f : futures) {
            if (f.isDone()) continue;
            return false;
        }
        return true;
    }

    private static void get(Iterable<Future<Object>> futures) throws ExecutionException, InterruptedException {
        for (Future<Object> f : futures) {
            f.get();
        }
    }

    private static Session createSession(Repository repository) throws RepositoryException {
        return repository.login(new SimpleCredentials("admin", "admin".toCharArray()));
    }

    private static class Listener
    implements EventListener {
        private final AtomicInteger eventCount;

        public Listener(AtomicInteger eventCount) {
            this.eventCount = eventCount;
        }

        @Override
        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                this.eventCount.incrementAndGet();
                events.nextEvent();
            }
        }
    }
}

