/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.util.OakIndexUtils;

public abstract class OrderedIndexBaseTest
extends AbstractTest {
    static final int NODES_PER_ITERATION = Integer.parseInt(System.getProperty("nodesPerIteration", "100"));
    static final int PRE_ADDED_NODES = Integer.parseInt(System.getProperty("preAddedNodes", "0"));
    static final String NODE_TYPE = "oak:Unstructured";
    static final String INDEXED_PROPERTY = "indexedProperty";
    static final int BATCH_SAVING_SIZE = Integer.parseInt(System.getProperty("batchSaving", "1024"));
    static final boolean BATCH_SAVING = BATCH_SAVING_SIZE > 0;
    final String DUMP_NODE = this.getClass().getSimpleName() + TEST_ID;
    Session session;
    Node dump;

    void insertRandomNodes(int numberOfNodes) {
        try {
            for (int i = 0; i < numberOfNodes; ++i) {
                String uuid = UUID.randomUUID().toString();
                this.dump.addNode(uuid, NODE_TYPE).setProperty(INDEXED_PROPERTY, uuid);
                if (this.isBatchSaving()) {
                    if (i % BATCH_SAVING_SIZE != 0) continue;
                    this.session.save();
                    continue;
                }
                this.session.save();
            }
            if (this.isBatchSaving()) {
                this.session.save();
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    void defineIndex() throws Exception {
    }

    Node defineStandardPropertyIndex(Session session) throws Exception {
        Node index = new OakIndexUtils.PropertyIndex().property(INDEXED_PROPERTY).create(session);
        if (index == null) {
            throw new RuntimeException("Error while creating the index definition. index node is null.");
        }
        if (!"property".equals(index.getProperty("type").getString())) {
            throw new RuntimeException("The type of the index does not match the expected");
        }
        session.save();
        return index;
    }

    Node defineOrderedPropertyIndex(Session session) throws Exception {
        Node index = new OakIndexUtils.PropertyIndex().property(INDEXED_PROPERTY).create(session, "ordered");
        if (index == null) {
            throw new RuntimeException("Error while creating the index definition. index node is null.");
        }
        if (!"ordered".equals(index.getProperty("type").getString())) {
            throw new RuntimeException("The index type does not match the expected");
        }
        session.save();
        return index;
    }

    boolean isBatchSaving() {
        return BATCH_SAVING;
    }
}

