/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.oak.benchmark.OrderedIndexBaseTest;

public abstract class OrderedIndexQueryBaseTest
extends OrderedIndexBaseTest {
    Node index;
    public static final String QUERY_WITH_ORDER = String.format("SELECT * FROM [%s] WHERE %s IS NOT NULL ORDER BY %s", "oak:Unstructured", "indexedProperty", "indexedProperty");
    public static final int FETCH_NODES = 100;
    public static final String QUERY_WITHOUT_ORDER = String.format("SELECT * FROM [%s] WHERE %s IS NOT NULL", "oak:Unstructured", "indexedProperty");

    @Override
    protected void beforeSuite() throws Exception {
        this.session = this.loginWriter();
        this.dump = this.session.getRootNode().addNode(this.DUMP_NODE, "oak:Unstructured");
        this.session.save();
        this.defineIndex();
        this.insertRandomNodes(PRE_ADDED_NODES);
    }

    @Override
    protected void afterSuite() throws Exception {
        this.dump.remove();
        if (this.index != null) {
            this.index.remove();
        }
        this.session.save();
        this.session.logout();
    }

    @Override
    protected void runTest() throws Exception {
        QueryManager qm = this.session.getWorkspace().getQueryManager();
        Query q = qm.createQuery(this.getQuery(), "JCR-SQL2");
        QueryResult r = q.execute();
        NodeIterator nodes = r.getNodes();
        int counter = 0;
        while (nodes.hasNext() && counter++ < 100) {
            nodes.next();
        }
    }

    abstract String getQuery();

    @Override
    boolean isBatchSaving() {
        return true;
    }
}

