/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.util.TraversingItemVisitor;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;

public class ReadDeepTreeTest
extends AbstractTest {
    protected final boolean runAsAdmin;
    protected final int itemsToRead;
    protected final boolean doReport;
    protected final boolean singleSession;
    protected Session adminSession;
    protected Node testRoot;
    protected Session testSession;
    protected List<String> allPaths = new ArrayList<String>();

    protected ReadDeepTreeTest(boolean runAsAdmin, int itemsToRead, boolean doReport) {
        this(runAsAdmin, itemsToRead, doReport, true);
    }

    public ReadDeepTreeTest(boolean runAsAdmin, int itemsToRead, boolean doReport, boolean singleSession) {
        this.runAsAdmin = runAsAdmin;
        this.itemsToRead = itemsToRead;
        this.doReport = doReport;
        this.singleSession = singleSession;
    }

    @Override
    protected void beforeSuite() throws Exception {
        this.adminSession = this.loginWriter();
        this.createDeepTree();
        this.testSession = this.singleSession ? this.getTestSession() : null;
    }

    protected void createDeepTree() throws Exception {
        Node rn = this.adminSession.getRootNode();
        this.allPaths.clear();
        String testNodeName = this.getTestNodeName();
        long start = System.currentTimeMillis();
        if (!rn.hasNode(testNodeName)) {
            this.testRoot = this.adminSession.getRootNode().addNode(testNodeName, "nt:unstructured");
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.getImportFileName());
            this.adminSession.importXML(this.testRoot.getPath(), in, 0);
            this.adminSession.save();
        } else {
            this.testRoot = rn.getNode(testNodeName);
        }
        System.out.println("Import deep tree: " + (System.currentTimeMillis() - start));
        TraversingItemVisitor.Default v = new TraversingItemVisitor.Default(){

            @Override
            protected void entering(Node node, int i) throws RepositoryException {
                ReadDeepTreeTest.this.visitingNode(node, i);
                super.entering(node, i);
            }

            @Override
            protected void entering(Property prop, int i) throws RepositoryException {
                ReadDeepTreeTest.this.visitingProperty(prop, i);
                super.entering(prop, i);
            }
        };
        v.visit(this.testRoot);
        System.out.println("All paths: " + this.allPaths.size());
    }

    protected String getImportFileName() {
        return "deepTree.xml";
    }

    protected String getTestNodeName() {
        return this.getClass().getSimpleName() + TEST_ID;
    }

    protected void visitingNode(Node node, int i) throws RepositoryException {
        this.allPaths.add(node.getPath());
    }

    protected void visitingProperty(Property property, int i) throws RepositoryException {
        this.allPaths.add(property.getPath());
    }

    @Override
    protected void afterSuite() throws Exception {
        this.testRoot.remove();
        this.adminSession.save();
    }

    @Override
    protected void runTest() throws Exception {
        this.randomRead(this.testSession, this.allPaths, this.itemsToRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void randomRead(Session testSession, List<String> allPaths, int cnt) throws RepositoryException {
        boolean logout = false;
        if (testSession == null) {
            testSession = this.getTestSession();
            logout = true;
        }
        try {
            int nodeCnt = 0;
            int propertyCnt = 0;
            int noAccess = 0;
            int size = allPaths.size();
            long start = System.currentTimeMillis();
            for (int i = 0; i < cnt; ++i) {
                double rand = (double)size * Math.random();
                int index = (int)Math.floor(rand);
                String path = allPaths.get(index);
                if (testSession.itemExists(path)) {
                    Item item = testSession.getItem(path);
                    if (item.isNode()) {
                        ++nodeCnt;
                        continue;
                    }
                    ++propertyCnt;
                    continue;
                }
                ++noAccess;
            }
            long end = System.currentTimeMillis();
            if (this.doReport) {
                System.out.println("Session " + testSession.getUserID() + " reading " + (cnt - noAccess) + " (Nodes: " + nodeCnt + "; Properties: " + propertyCnt + ") completed in " + (end - start));
            }
        }
        finally {
            if (logout) {
                this.logout(testSession);
            }
        }
    }

    protected Session getTestSession() {
        if (this.runAsAdmin) {
            return this.loginWriter();
        }
        return this.loginAnonymous();
    }
}

