/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;

abstract class ReadManyTest
extends AbstractTest {
    private static final Random RANDOM = new Random(1234567890L);
    public static final Content EMPTY = new Content(){

        @Override
        public void create(Node parent, String name) throws RepositoryException {
            parent.addNode(name);
        }

        @Override
        public void read(Node node) {
        }
    };
    public static final Content FILES = new Content(){

        @Override
        public void create(Node parent, String name) throws RepositoryException {
            byte[] randomBytes = new byte[10240];
            RANDOM.nextBytes(randomBytes);
            ByteArrayInputStream stream = new ByteArrayInputStream(randomBytes);
            JcrUtils.putFile(parent, name, "application/octet-stream", stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read(Node node) throws RepositoryException {
            Binary binary = node.getProperty("jcr:content/jcr:data").getBinary();
            try {
                InputStream stream = binary.getStream();
                try {
                    ByteStreams.copy(stream, ByteStreams.nullOutputStream());
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RepositoryException("Unexpected IOException", e);
            }
            finally {
                binary.dispose();
            }
        }
    };
    public static final Content NODES = new Content(){

        @Override
        public void create(Node parent, String name) throws RepositoryException {
            Node node = parent.addNode(name);
            for (int i = 0; i < 10; ++i) {
                char[] randomText = new char[1000];
                for (int j = 0; j < randomText.length; ++j) {
                    randomText[j] = j % 10 != 0 ? (int)(97 + RANDOM.nextInt(25)) : 32;
                }
                Node child = node.addNode("node" + i);
                child.setProperty("title", "child" + i);
                child.setProperty("content", new String(randomText));
            }
        }

        @Override
        public void read(Node node) throws RepositoryException {
            for (Node child : JcrUtils.getChildNodes(node)) {
                child.getProperty("title").getString();
                child.getProperty("content").getString();
            }
        }
    };
    private final String name;
    protected final int scale;
    protected final Content content;
    private Session session;
    protected Node root;

    public static ReadManyTest linear(String name, int scale, Content content) {
        return new ReadManyTest(name, scale, content){

            @Override
            protected void runTest() throws Exception {
                Node top = this.root.getNode("node" + RANDOM.nextInt(this.scale));
                Node middle = top.getNode("node" + RANDOM.nextInt(1000));
                for (Node bottom : JcrUtils.getChildNodes(middle)) {
                    this.content.read(bottom);
                }
            }
        };
    }

    public static ReadManyTest uniform(String name, int scale, Content content) {
        return new ReadManyTest(name, scale, content){

            @Override
            protected void runTest() throws Exception {
                for (int i = 0; i < 1000; ++i) {
                    this.content.read(this.root.getNode("node" + RANDOM.nextInt(this.scale)).getNode("node" + RANDOM.nextInt(1000)).getNode("node" + RANDOM.nextInt(1000)));
                }
            }
        };
    }

    protected ReadManyTest(String name, int scale, Content content) {
        this.name = name;
        this.scale = scale;
        this.content = content;
    }

    @Override
    protected void beforeSuite() throws Exception {
        this.session = this.getRepository().login(this.getCredentials());
        this.root = this.session.getRootNode().addNode("c" + TEST_ID);
        for (int i = 0; i < this.scale; ++i) {
            Node top = this.root.addNode("node" + i);
            for (int j = 0; j < 1000; ++j) {
                Node middle = top.addNode("node" + j);
                for (int k = 0; k < 1000; ++k) {
                    this.content.create(middle, "node" + k);
                }
                this.session.save();
            }
        }
    }

    @Override
    protected void afterSuite() throws Exception {
        for (int i = 0; i < this.scale; ++i) {
            Node top = this.root.getNode("node" + i);
            for (int j = 0; j < 1000; ++j) {
                top.getNode("node" + j).remove();
                this.session.save();
            }
        }
        this.root.remove();
        this.session.save();
        this.session.logout();
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static interface Content {
        public void create(Node var1, String var2) throws RepositoryException;

        public void read(Node var1) throws RepositoryException;
    }
}

