/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Slf4jReporter;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.management.MBeanServer;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.plugins.metric.MetricStatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadPropertyTest
extends AbstractTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Session session;
    private Node root;

    @Override
    protected void beforeSuite() throws Exception {
        this.session = this.getRepository().login(this.getCredentials());
        this.root = this.session.getRootNode().addNode(this.getClass().getSimpleName() + TEST_ID, "nt:unstructured");
        this.root.setProperty("property", "value");
        this.session.save();
    }

    @Override
    protected void runTest() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            this.root.getProperty("jcr:primaryType");
            this.root.getProperty("property");
            this.root.hasProperty("does-not-exist");
        }
    }

    @Override
    protected void afterSuite() throws Exception {
        this.root.remove();
        this.session.save();
        this.session.logout();
    }

    @Override
    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        if (fixture instanceof OakRepositoryFixture) {
            return ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                @Override
                public Jcr customize(Oak oak) {
                    boolean enableMetrics = Boolean.getBoolean("enableMetrics");
                    if (enableMetrics) {
                        ReadPropertyTest.this.log.info("Enabling Metrics integration");
                        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                        ScheduledExecutorService executor = MoreExecutors.getExitingScheduledExecutorService(new ScheduledThreadPoolExecutor(1));
                        MetricStatisticsProvider statsProvider = new MetricStatisticsProvider(server, executor);
                        oak.getWhiteboard().register(StatisticsProvider.class, statsProvider, Collections.emptyMap());
                        Slf4jReporter reporter = Slf4jReporter.forRegistry(statsProvider.getRegistry()).outputTo(LoggerFactory.getLogger("org.apache.jackrabbit.oak.metrics")).convertRatesTo(TimeUnit.SECONDS).filter(new MetricFilter(){

                            @Override
                            public boolean matches(String name, Metric metric) {
                                return name.startsWith("SESSION_READ");
                            }
                        }).convertDurationsTo(TimeUnit.MICROSECONDS).build();
                        reporter.start(30L, TimeUnit.SECONDS);
                    }
                    return new Jcr(oak);
                }
            });
        }
        return super.createRepository(fixture);
    }
}

