/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.util.concurrent.UncheckedExecutionException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.oak.benchmark.Benchmark;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;

public class ReplicaCrashResilienceTest
extends Benchmark {
    private static final String LEVEL2POINTER = "level2pointer";
    private static final String LEVEL1POINTER = "level1pointer";
    private static final String WRITER_INFOS = "writerInfos";
    private static final String REPLICA_CRASH_TEST = "replicaCrashTest-" + System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Iterable<RepositoryFixture> fixtures) {
        for (RepositoryFixture fixture : fixtures) {
            if (!fixture.isAvailable(1)) continue;
            System.out.format("%s: ReplicaCrashResilienceTest%n", fixture);
            try {
                Repository[] cluster = fixture.setUpCluster(1);
                try {
                    this.run(cluster[0]);
                }
                finally {
                    fixture.tearDownCluster();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private void run(final Repository repository) throws Exception {
        System.out.println("Setup...");
        try {
            Session session = repository.login(new SimpleCredentials("admin", "admin".toCharArray()));
            Node rootNode = session.getRootNode();
            if (rootNode.hasNode(REPLICA_CRASH_TEST)) {
                rootNode.getNode(REPLICA_CRASH_TEST).remove();
                session.save();
            }
            session.refresh(false);
            Node replicaCrashTestNode = rootNode.addNode(REPLICA_CRASH_TEST);
            replicaCrashTestNode.addNode(WRITER_INFOS);
            session.save();
        }
        catch (RepositoryException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        Runnable writer = new Runnable(){

            @Override
            public void run() {
                int level1Pointer = 1;
                int level2Pointer = 1;
                Session session = null;
                try {
                    session = repository.login(new SimpleCredentials("admin", "admin".toCharArray()));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    System.exit(1);
                }
                System.out.println("Writer: Test start.");
                while (true) {
                    try {
                        Node level1Node;
                        String level1 = String.valueOf(level1Pointer);
                        String level2 = String.valueOf(level2Pointer);
                        Node rootNode = session.getRootNode();
                        Node replicaCrashTestNode = rootNode.getNode(REPLICA_CRASH_TEST);
                        Node writerInfosNode = replicaCrashTestNode.getNode(ReplicaCrashResilienceTest.WRITER_INFOS);
                        if (replicaCrashTestNode.hasNode(level1)) {
                            level1Node = replicaCrashTestNode.getNode(level1);
                        } else {
                            level1Node = replicaCrashTestNode.addNode(level1);
                            System.out.println("Writer: Created level1 node: " + level1Node);
                        }
                        Node level2Node = level1Node.addNode(level2);
                        System.out.println("Writer: Created level2 node: " + level2Node);
                        writerInfosNode.setProperty(ReplicaCrashResilienceTest.LEVEL1POINTER, level1Pointer);
                        writerInfosNode.setProperty(ReplicaCrashResilienceTest.LEVEL2POINTER, level2Pointer);
                        session.save();
                    }
                    catch (UncheckedExecutionException e) {
                        System.out.println("Got an UncheckedException (levels: " + level1Pointer + "/" + level2Pointer + ") from the google cache probably: " + e);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e2) {
                            e.printStackTrace();
                            System.exit(1);
                        }
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.out);
                        System.exit(1);
                    }
                    if (++level2Pointer <= 1000) continue;
                    level2Pointer = 1;
                    ++level1Pointer;
                }
            }
        };
        Thread th1 = new Thread(writer);
        System.out.println("Launching writer...");
        th1.start();
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                long level1Pointer = 1L;
                long level2Pointer = 1L;
                Session session = null;
                try {
                    session = repository.login(new SimpleCredentials("admin", "admin".toCharArray()));
                    Node rootNode = session.getRootNode();
                    Node replicaCrashTestNode = rootNode.getNode(REPLICA_CRASH_TEST);
                    block9: while (true) {
                        try {
                            String level2;
                            String level1;
                            while (true) {
                                level1 = String.valueOf(level1Pointer);
                                level2 = String.valueOf(level2Pointer);
                                session.refresh(false);
                                Node writerInfos = replicaCrashTestNode.getNode(ReplicaCrashResilienceTest.WRITER_INFOS);
                                long writerLevel1Pointer = writerInfos.getProperty(ReplicaCrashResilienceTest.LEVEL1POINTER).getLong();
                                long writerLevel2Pointer = writerInfos.getProperty(ReplicaCrashResilienceTest.LEVEL2POINTER).getLong();
                                long writerPointer = writerLevel1Pointer * 1000L + writerLevel2Pointer;
                                long myPointer = level1Pointer * 1000L + level2Pointer;
                                long diff = writerPointer - myPointer;
                                if (diff >= 100L) break;
                                System.out.println("Reader: Closer than 100, waiting...level1=" + level1 + ", level2=" + level2);
                                try {
                                    Thread.sleep(1000L);
                                    continue block9;
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                    System.exit(1);
                                    continue;
                                }
                                break;
                            }
                            rootNode = session.getRootNode();
                            replicaCrashTestNode = rootNode.getNode(REPLICA_CRASH_TEST);
                            Node level1Node = replicaCrashTestNode.getNode(level1);
                            if (!level1Node.hasNode(level2)) {
                                System.err.println("Reader: NOT FOUND: level1=" + level1 + ", level2=" + level2);
                                Thread.sleep(500L);
                                session.refresh(false);
                                System.err.println("Reader: Reverifying once...");
                                rootNode = session.getRootNode();
                                replicaCrashTestNode = rootNode.getNode(REPLICA_CRASH_TEST);
                                level1Node = replicaCrashTestNode.getNode(level1);
                                boolean hasNode = level1Node.hasNode(level2);
                                if (hasNode) {
                                    System.err.println("Reader: yup, exists: " + hasNode + ", level1=" + level1 + ", level2=" + level2);
                                } else {
                                    System.err.println("Reader: not found: level1=" + level1 + ", level2=" + level2);
                                }
                            } else {
                                Node level2Node = level1Node.getNode(level2);
                                System.out.println("Reader: verified level1=" + level1 + ", level2=" + level2);
                            }
                        }
                        catch (UncheckedExecutionException e) {
                            System.out.println("Got an UncheckedException from the google cache probably: " + e);
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e2) {
                                e.printStackTrace();
                                System.exit(1);
                            }
                            continue;
                        }
                        catch (Throwable e) {
                            e.printStackTrace(System.out);
                            System.exit(1);
                        }
                        if (++level2Pointer <= 1000L) continue;
                        level2Pointer = 1L;
                        ++level1Pointer;
                    }
                }
                catch (RepositoryException e1) {
                    e1.printStackTrace(System.out);
                    System.exit(1);
                    System.out.println("Test start.");
                    return;
                }
            }
        };
        Thread th2 = new Thread(reader);
        Thread.sleep(1000L);
        th2.start();
        System.out.println("Waiting for writer to finish...");
        th1.join();
    }
}

