/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.benchmark.wikipedia.WikipediaImport;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakFixture;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneIndexHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneInitializerHelper;

public class RepositoryGrowthTest
extends WikipediaImport {
    private final boolean luceneIndexOnFS;
    private final File basedir;
    private final Map<RepositoryFixture, File> indexDirs = Maps.newHashMap();

    public RepositoryGrowthTest(File dump, File basedir, boolean luceneIndexOnFS) {
        super(dump, true, true);
        this.luceneIndexOnFS = luceneIndexOnFS;
        this.basedir = basedir;
    }

    @Override
    protected Repository[] setupCluster(final RepositoryFixture fixture) throws Exception {
        if (fixture instanceof OakRepositoryFixture) {
            return ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                @Override
                public Jcr customize(Oak oak) {
                    LuceneIndexProvider provider = new LuceneIndexProvider();
                    String path = null;
                    if (RepositoryGrowthTest.this.luceneIndexOnFS) {
                        File indexDir = new File(RepositoryGrowthTest.this.basedir, "lucene-" + System.currentTimeMillis());
                        path = indexDir.getAbsolutePath();
                        RepositoryGrowthTest.this.indexDirs.put(fixture, indexDir);
                    }
                    oak.with(provider).with(provider).with(new LuceneIndexEditorProvider()).with(new LuceneInitializerHelper("luceneGlobal", LuceneIndexHelper.JR_PROPERTY_INCLUDES, null, path, null));
                    return new Jcr(oak);
                }
            });
        }
        return super.setupCluster(fixture);
    }

    @Override
    protected void tearDown(RepositoryFixture fixture) throws IOException {
        OakFixture oakFixture;
        if (fixture instanceof OakRepositoryFixture && (oakFixture = ((OakRepositoryFixture)fixture).getOakFixture()) instanceof OakFixture.SegmentFixture) {
            File indexDir;
            OakFixture.SegmentFixture sf = (OakFixture.SegmentFixture)oakFixture;
            long size = sf.getStores()[0].size();
            if (sf.getBlobStoreFixtures().length > 0) {
                size = sf.getBlobStoreFixtures()[0].size();
            }
            if ((indexDir = this.indexDirs.get(fixture)) != null) {
                size += FileUtils.sizeOfDirectory(indexDir);
            }
            System.out.printf("Repository size %s %s %n", fixture, IOUtils.humanReadableByteCount(size));
        }
        super.tearDown(fixture);
    }

    @Override
    protected void batchDone(Session session, long start, int count) throws RepositoryException {
        session.save();
        super.batchDone(session, start, count);
    }
}

