/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.base.Stopwatch;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.Benchmark;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class RevisionGCTest
extends Benchmark {
    protected static final float GARBAGE_RATIO = Float.parseFloat(System.getProperty("garbageRatio", "0.5"));
    protected static final String NODE_TYPE = System.getProperty("nodeType", "nt:unstructured");
    protected static final int SCALE = AbstractTest.getScale(100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Iterable<RepositoryFixture> fixtures) {
        for (RepositoryFixture fixture : fixtures) {
            if (!fixture.isAvailable(1)) continue;
            System.out.format("%s: RevisionGC benchmark%n", fixture);
            try {
                final AtomicReference whiteboardRef = new AtomicReference();
                if (!(fixture instanceof OakRepositoryFixture)) {
                    System.err.format("%s: RevisionGC benchmark only runs on Oak%n", fixture);
                    return;
                }
                Repository[] cluster = ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                    @Override
                    public Jcr customize(Oak oak) {
                        whiteboardRef.set(oak);
                        return new Jcr(oak);
                    }
                });
                try {
                    this.run(cluster[0], RevisionGCTest.getNodeStore((Oak)whiteboardRef.get()));
                }
                finally {
                    fixture.tearDownCluster();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(Repository repository, NodeStore nodeStore) throws Exception {
        Session s = RevisionGCTest.createSession(repository);
        Random rand = new Random();
        try {
            System.out.print("Creating garbage ");
            for (int i = 0; i < SCALE; ++i) {
                Node n = s.getRootNode().addNode("node-" + i);
                for (int j = 0; j < 1000; ++j) {
                    n.addNode("child-" + j, NODE_TYPE);
                }
                s.save();
                if (rand.nextFloat() <= GARBAGE_RATIO) {
                    n.remove();
                    s.save();
                }
                System.out.print(".");
            }
            System.out.println();
            System.out.println("Running RevisionGC");
            Stopwatch sw = Stopwatch.createStarted();
            String result = RevisionGCTest.revisionGC(nodeStore);
            sw.stop();
            System.out.println(result);
            System.out.println("Performed RevisionGC in " + sw);
        }
        finally {
            s.logout();
        }
    }

    protected static String revisionGC(NodeStore nodeStore) throws Exception {
        if (nodeStore instanceof DocumentNodeStore) {
            return ((DocumentNodeStore)nodeStore).getVersionGarbageCollector().gc(0L, TimeUnit.SECONDS).toString();
        }
        if (nodeStore instanceof SegmentNodeStore) {
            Field f = SegmentNodeStore.class.getDeclaredField("store");
            f.setAccessible(true);
            ((SegmentStore)f.get(nodeStore)).gc();
            return "";
        }
        throw new IllegalArgumentException("Unknown node store: " + nodeStore.getClass().getName());
    }

    protected static NodeStore getNodeStore(Oak oak) throws Exception {
        Field f = Oak.class.getDeclaredField("store");
        f.setAccessible(true);
        return (NodeStore)f.get(oak);
    }

    protected static Session createSession(Repository repository) throws RepositoryException {
        return repository.login(new SimpleCredentials("admin", "admin".toCharArray()));
    }
}

