/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;

public class SequentialCreateNodesTest
extends AbstractTest {
    protected static final String ROOT_NODE_NAME = "test" + TEST_ID;
    private static final int NODE_COUNT = 25;

    @Override
    public void beforeTest() throws Exception {
        Session session = this.loginWriter();
        Node root = session.getRootNode().addNode(ROOT_NODE_NAME, "nt:unstructured");
        for (int i = 0; i < 25; ++i) {
            Node node = root.addNode("node" + i, "nt:unstructured");
            session.save();
        }
    }

    @Override
    protected void runTest() throws Exception {
        Session session = this.loginWriter();
        Node root = session.getRootNode().getNode(ROOT_NODE_NAME);
        for (int i = 0; i < 25; ++i) {
            Node node = root.getNode("node" + i);
            for (int j = 0; j < 25; ++j) {
                Node newNode = node.addNode("node" + j, "nt:unstructured");
                session.save();
            }
        }
    }

    @Override
    public void afterTest() throws Exception {
        Session session = this.loginWriter();
        Node root = session.getRootNode().getNode(ROOT_NODE_NAME);
        root.remove();
        session.save();
    }
}

