/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;

public class SetMultiPropertyTest
extends AbstractTest {
    private static final String[] VALUES = SetMultiPropertyTest.createValues(100);
    private Session session;
    private Node node;
    String testNodeName = "test" + TEST_ID;

    private static String[] createValues(int count) {
        String[] values = new String[count];
        for (int k = 0; k < values.length; ++k) {
            values[k] = "value" + k;
        }
        return values;
    }

    @Override
    public void beforeSuite() throws RepositoryException {
        this.session = this.getRepository().login(this.getCredentials());
        this.node = this.session.getRootNode().addNode(this.testNodeName, "nt:unstructured");
        this.session.save();
    }

    @Override
    public void beforeTest() throws RepositoryException {
        this.node.setProperty("count", new String[0]);
        this.session.save();
    }

    @Override
    public void runTest() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            this.node.setProperty("count", VALUES);
            this.session.save();
        }
    }

    @Override
    public void afterTest() throws RepositoryException {
    }

    @Override
    public void afterSuite() throws RepositoryException {
        this.session.getRootNode().getNode(this.testNodeName).remove();
        this.session.save();
        this.session.logout();
    }
}

