/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;

public class SetPropertyTest
extends AbstractTest {
    private Map<Thread, Node> nodes = Maps.newIdentityHashMap();
    String testNodeName = "test" + TEST_ID;

    @Override
    public void beforeSuite() throws RepositoryException {
        Session session = this.getRepository().login(this.getCredentials());
        session.getRootNode().addNode(this.testNodeName, this.getUnstructuredNodeType(session));
        session.save();
        session.logout();
    }

    @Override
    public void beforeTest() throws RepositoryException {
        Thread t = Thread.currentThread();
        Node node = this.nodes.get(t);
        if (node == null) {
            Session s = this.getRepository().login(this.getCredentials());
            node = s.getRootNode().getNode(this.testNodeName).addNode(UUID.randomUUID().toString());
            node.setProperty("count", -1L);
            s.save();
            this.nodes.put(t, node);
        }
    }

    @Override
    public void runTest() throws Exception {
        Node node = this.nodes.get(Thread.currentThread());
        Session session = node.getSession();
        for (int i = 0; i < 1000; ++i) {
            node.setProperty("count", i);
            session.save();
        }
    }

    @Override
    public void afterSuite() throws RepositoryException {
        Session session = this.getRepository().login(this.getCredentials());
        session.getRootNode().getNode(this.testNodeName).remove();
        session.save();
        session.logout();
    }

    private String getUnstructuredNodeType(Session s) throws RepositoryException {
        NodeTypeManager ntMgr = s.getWorkspace().getNodeTypeManager();
        if (ntMgr.hasNodeType("oak:Unstructured")) {
            return "oak:Unstructured";
        }
        return "nt:unstructured";
    }
}

