/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.util.OakIndexUtils;

public class SimpleSearchTest
extends AbstractTest {
    private static final int NODE_COUNT = 100;
    private Session session;
    private Node root;

    protected Query createQuery(QueryManager manager, int i) throws RepositoryException {
        String xpath = "xpath";
        return manager.createQuery("//*[@testcount=" + i + "]", xpath);
    }

    @Override
    public void beforeSuite() throws RepositoryException {
        this.session = this.getRepository().login(this.getCredentials());
        try {
            this.ensurePropertyIndex();
        }
        catch (InvalidItemStateException e) {
            this.session.refresh(false);
            this.ensurePropertyIndex();
        }
        this.root = this.session.getRootNode().addNode("testroot" + TEST_ID, "nt:unstructured");
        for (int i = 0; i < 100; ++i) {
            Node node = this.root.addNode("node" + i, "nt:unstructured");
            for (int j = 0; j < 100; ++j) {
                Node child = node.addNode("node" + j, "nt:unstructured");
                child.setProperty("testcount", j);
            }
            this.session.save();
        }
    }

    @Override
    public void runTest() throws Exception {
        QueryManager manager = this.session.getWorkspace().getQueryManager();
        for (int i = 0; i < 100; ++i) {
            Query query = this.createQuery(manager, i);
            NodeIterator iterator = query.execute().getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                if (node.getProperty("testcount").getLong() == (long)i) continue;
                throw new Exception("Invalid test result: " + node.getPath());
            }
        }
    }

    @Override
    public void afterSuite() throws RepositoryException {
        for (int i = 0; i < 100; ++i) {
            this.root.getNode("node" + i).remove();
            this.session.save();
        }
        this.root.remove();
        this.session.save();
        this.session.logout();
    }

    private void ensurePropertyIndex() throws RepositoryException {
        new OakIndexUtils.PropertyIndex().property("testcount").create(this.session);
    }
}

