/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.TestInputStream;

public class SmallFileReadTest
extends AbstractTest {
    private static final int FILE_COUNT = 1000;
    private static final int FILE_SIZE = Integer.getInteger("file.size", 10);
    private Session session;
    private Node root;

    @Override
    public void beforeSuite() throws RepositoryException {
        this.session = this.getRepository().login(this.getCredentials());
        this.root = this.session.getRootNode().addNode(this.getClass().getSimpleName() + TEST_ID, "nt:folder");
        for (int i = 0; i < 1000; ++i) {
            Node file = this.root.addNode("file" + i, "nt:file");
            Node content = file.addNode("jcr:content", "nt:resource");
            content.setProperty("jcr:mimeType", "application/octet-stream");
            content.setProperty("jcr:lastModified", Calendar.getInstance());
            content.setProperty("jcr:data", new TestInputStream(FILE_SIZE * 1024));
        }
        this.session.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTest() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            Node file = this.root.getNode("file" + i);
            Node content = file.getNode("jcr:content");
            InputStream stream = content.getProperty("jcr:data").getStream();
            try {
                ByteStreams.copy(stream, ByteStreams.nullOutputStream());
                continue;
            }
            finally {
                stream.close();
            }
        }
    }

    @Override
    public void afterSuite() throws RepositoryException {
        this.root.remove();
        this.session.save();
        this.session.logout();
    }
}

