/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.TestInputStream;

public class SmallFileWriteTest
extends AbstractTest {
    private static final int FILE_COUNT = 100;
    private static final int FILE_SIZE = 10;
    private Session session;
    private Node root;
    private int iteration = 0;

    @Override
    public void beforeSuite() throws RepositoryException {
        this.session = this.loginWriter();
    }

    @Override
    public void beforeTest() throws RepositoryException {
        this.root = this.session.getRootNode().addNode("SmallFileWrite" + TEST_ID + this.iteration++, "nt:folder");
        this.session.save();
    }

    @Override
    public void runTest() throws Exception {
        for (int i = 0; i < 100; ++i) {
            Node file = this.root.addNode("file" + i, "nt:file");
            Node content = file.addNode("jcr:content", "nt:resource");
            content.setProperty("jcr:mimeType", "application/octet-stream");
            content.setProperty("jcr:lastModified", Calendar.getInstance());
            content.setProperty("jcr:data", new TestInputStream(10240));
        }
        this.session.save();
    }

    @Override
    public void afterTest() throws RepositoryException {
        this.root.remove();
        this.session.save();
    }
}

