/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import java.util.UUID;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;
import org.apache.jackrabbit.oak.benchmark.util.OakIndexUtils;

public class UUIDLookupTest
extends AbstractTest {
    private static final int NODE_COUNT = 100;
    private int noOfIndex = Integer.getInteger("noOfIndex", 60);
    private boolean lookupByQuery = Boolean.getBoolean("lookupByQuery");
    private Session session;
    private Node root;

    protected Query createQuery(QueryManager manager, int i) throws RepositoryException {
        return manager.createQuery("SELECT * FROM [nt:base] WHERE [jcr:uuid] = " + i, "JCR-SQL2");
    }

    @Override
    public void beforeSuite() throws RepositoryException {
        this.session = this.getRepository().login(this.getCredentials());
        try {
            this.ensurePropertyIndexes();
        }
        catch (InvalidItemStateException e) {
            this.session.refresh(false);
            this.ensurePropertyIndexes();
        }
        this.root = this.session.getRootNode().addNode("testroot" + TEST_ID, "nt:unstructured");
        for (int i = 0; i < 100; ++i) {
            Node node = this.root.addNode("node" + i, "nt:unstructured");
            node.setProperty("jcr:uuid", UUIDLookupTest.createUUID(i));
            this.session.save();
        }
        String lookupMode = this.lookupByQuery ? "query" : "Session#getNodeByIdentifier";
        System.out.printf("No of indexes (%s) %d, Lookup by (%s)[%s] %n", this.noOfIndex, this.noOfIndex, "lookupByQuery", lookupMode);
    }

    @Override
    public void runTest() throws Exception {
        if (this.lookupByQuery) {
            QueryManager manager = this.session.getWorkspace().getQueryManager();
            for (int i = 0; i < 100; ++i) {
                Query query = this.createQuery(manager, i);
                NodeIterator iterator = query.execute().getNodes();
                while (iterator.hasNext()) {
                    Node node = iterator.nextNode();
                    if (node.getProperty("jcr:uuid").getLong() == (long)i) continue;
                    throw new Exception("Invalid test result: " + node.getPath());
                }
            }
        } else {
            for (int i = 0; i < 100; ++i) {
                this.session.getNodeByIdentifier(UUIDLookupTest.createUUID(i));
            }
        }
    }

    @Override
    public void afterSuite() throws RepositoryException {
        for (int i = 0; i < 100; ++i) {
            this.root.getNode("node" + i).remove();
            this.session.save();
        }
        this.root.remove();
        this.session.save();
        this.session.logout();
    }

    private void ensurePropertyIndexes() throws RepositoryException {
        for (int i = 0; i < this.noOfIndex; ++i) {
            new OakIndexUtils.PropertyIndex().property("testcount" + i).create(this.session);
        }
    }

    private static String createUUID(int i) {
        return new UUID(0L, i).toString();
    }
}

