/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.oak.benchmark.AbstractTest;

public class UpdateManyChildNodesTest
extends AbstractTest {
    protected static final String ROOT_NODE_NAME = "update" + TEST_ID;
    protected static final int CHILD_COUNT = 10000;
    private Session session;
    private Node node;
    private int count;

    @Override
    public void beforeSuite() throws RepositoryException {
        this.session = this.getRepository().login(this.getCredentials());
        this.node = this.session.getRootNode().addNode(ROOT_NODE_NAME, "nt:folder");
        for (int i = 0; i < 10000; ++i) {
            this.node.addNode("node" + i, "nt:folder");
            if (i % 1000 != 0) continue;
            this.session.save();
        }
        this.session.save();
    }

    @Override
    public void beforeTest() throws RepositoryException {
        ++this.count;
    }

    @Override
    public void runTest() throws Exception {
        this.node.addNode("onemore" + this.count, "nt:folder");
        this.session.save();
    }

    @Override
    public void afterTest() throws RepositoryException {
        this.node.getNode("onemore" + this.count).remove();
        this.session.save();
    }

    @Override
    public void afterSuite() throws RepositoryException {
        this.session.getRootNode().getNode(ROOT_NODE_NAME).remove();
        this.session.save();
        this.session.logout();
    }
}

