/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark.util;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;

public enum Date {
    NOW(Calendar.getInstance()),
    LAST_2_HRS(Date.add(NOW.getCalendar(), 11, -2)),
    LAST_24_HRS(Date.add(NOW.getCalendar(), 11, -24)),
    LAST_7_DAYS(Date.add(NOW.getCalendar(), 11, -168)),
    LAST_MONTH(Date.add(NOW.getCalendar(), 2, -1)),
    LAST_YEAR(Date.add(NOW.getCalendar(), 1, -1));

    private final Calendar cal;
    private static final List<Date> VALUES;
    private static final int SIZE;
    private static final Random RND;

    private static Calendar add(Calendar cal, int field, int amount) {
        cal.add(field, amount);
        return cal;
    }

    private Date(Calendar cal) {
        this.cal = cal;
    }

    public Calendar getCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.cal.getTime());
        return c;
    }

    public String toISO_8601_2000() {
        return Date.convertToISO_8601_2000(this.getCalendar());
    }

    public static Date randomDate() {
        return VALUES.get(RND.nextInt(SIZE));
    }

    public static String convertToISO_8601_2000(Calendar cal) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(cal.getTime());
    }

    static {
        VALUES = Collections.unmodifiableList(Arrays.asList(Date.values()));
        SIZE = VALUES.size();
        RND = new Random(30L);
    }
}

