/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.commons.JcrUtils;

public class OakIndexUtils {
    public static Node propertyIndexDefinition(Session session, String indexDefinitionName, String[] propertyNames, boolean unique, String[] enclosingNodeTypes) throws RepositoryException {
        Node root = session.getRootNode();
        Node indexDefRoot = JcrUtils.getOrAddNode(root, "oak:index", "nt:unstructured");
        Node indexDef = JcrUtils.getOrAddNode(indexDefRoot, indexDefinitionName, "oak:QueryIndexDefinition");
        indexDef.setProperty("type", "property");
        indexDef.setProperty("reindex", true);
        indexDef.setProperty("propertyNames", propertyNames, 7);
        indexDef.setProperty("unique", unique);
        if (enclosingNodeTypes != null && enclosingNodeTypes.length != 0) {
            indexDef.setProperty("declaringNodeTypes", enclosingNodeTypes, 7);
        }
        session.save();
        return indexDef;
    }

    public static Node orderedIndexDefinition(Session session, String indexDefinitionName, String async, String[] propertyNames, boolean unique, String[] enclosingNodeTypes, String direction) throws RepositoryException {
        Node root = session.getRootNode();
        Node indexDefRoot = JcrUtils.getOrAddNode(root, "oak:index", "nt:unstructured");
        Node indexDef = JcrUtils.getOrAddNode(indexDefRoot, indexDefinitionName, "oak:QueryIndexDefinition");
        indexDef.setProperty("type", "ordered");
        indexDef.setProperty("propertyNames", propertyNames, 7);
        if (enclosingNodeTypes != null && enclosingNodeTypes.length != 0) {
            indexDef.setProperty("declaringNodeTypes", enclosingNodeTypes, 7);
        }
        if (direction != null) {
            indexDef.setProperty("direction", direction);
        }
        if (async != null) {
            indexDef.setProperty("async", async);
        }
        indexDef.setProperty("unique", unique);
        indexDef.setProperty("reindex", true);
        session.save();
        return indexDef;
    }

    public static Node luceneIndexDefinition(Session session, String indexDefinitionName, String async, String[] propertyNames, String[] type, Map<String, Map<String, String>> orderedPropsMap, String persistencePath) throws RepositoryException {
        Node root = session.getRootNode();
        Node indexDefRoot = JcrUtils.getOrAddNode(root, "oak:index", "nt:unstructured");
        Node indexDef = JcrUtils.getOrAddNode(indexDefRoot, indexDefinitionName, "oak:QueryIndexDefinition");
        indexDef.setProperty("type", "lucene");
        indexDef.setProperty("fulltextEnabled", false);
        if (async != null) {
            indexDef.setProperty("async", async);
        }
        indexDef.setProperty("includePropertyNames", propertyNames, 7);
        Node propsNode = JcrUtils.getOrAddNode(indexDef, "properties");
        for (int i = 0; i < propertyNames.length; ++i) {
            Node propNode = JcrUtils.getOrAddNode(propsNode, propertyNames[i], "oak:Unstructured");
            propNode.setProperty("type", type[i]);
        }
        if (orderedPropsMap != null && !orderedPropsMap.isEmpty()) {
            ArrayList<String> orderedProps = Lists.newArrayList();
            for (Map.Entry<String, Map<String, String>> orderedPropEntry : orderedPropsMap.entrySet()) {
                Node propNode = JcrUtils.getOrAddNode(propsNode, orderedPropEntry.getKey(), "oak:Unstructured");
                propNode.setProperty("type", orderedPropEntry.getValue().get("type"));
                orderedProps.add(orderedPropEntry.getKey());
            }
            if (!orderedProps.isEmpty()) {
                indexDef.setProperty("orderedProps", orderedProps.toArray(new String[orderedProps.size()]), 7);
            }
        }
        if (!Strings.isNullOrEmpty(persistencePath)) {
            indexDef.setProperty("persistence", "file");
            indexDef.setProperty("path", persistencePath);
        }
        session.save();
        return indexDef;
    }

    public static class PropertyIndex {
        private String indexName;
        private String propertyName;
        private String[] nodeTypeNames;

        public PropertyIndex name(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public PropertyIndex property(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public PropertyIndex nodeTypes(String ... nodeTypeNames) {
            this.nodeTypeNames = nodeTypeNames;
            return this;
        }

        @Nullable
        public Node create(Session session) throws RepositoryException {
            return this.create(session, "property");
        }

        @Nullable
        public Node create(Session session, String indexType) throws RepositoryException {
            Node indexDef;
            Node root;
            if (!session.getWorkspace().getNodeTypeManager().hasNodeType("oak:QueryIndexDefinition")) {
                return null;
            }
            if (session.hasPendingChanges()) {
                throw new RepositoryException("The session has pending changes");
            }
            if (this.indexName == null) {
                this.indexName = this.propertyName;
            }
            if (this.propertyName == null) {
                throw new RepositoryException("Index property name not set");
            }
            if (this.nodeTypeNames != null) {
                if (this.nodeTypeNames.length == 0) {
                    this.nodeTypeNames = null;
                } else {
                    Arrays.sort(this.nodeTypeNames);
                }
            }
            if (!(root = session.getRootNode()).hasNode("oak:index")) {
                indexDef = root.addNode("oak:index", "nt:unstructured");
                session.save();
            } else {
                indexDef = root.getNode("oak:index");
            }
            if (indexDef.hasNode(this.indexName)) {
                Property p;
                Node index = indexDef.getNode(this.indexName);
                if (index.hasProperty("unique") && (p = index.getProperty("unique")).getBoolean()) {
                    throw new RepositoryException("Index already exists, but is unique");
                }
                String type = index.getProperty("type").getString();
                if (!type.equals(indexType)) {
                    throw new RepositoryException("Index already exists, but is of type " + type);
                }
                Value[] v = index.getProperty("propertyNames").getValues();
                if (v.length != 1) {
                    Object[] list = new String[v.length];
                    for (int i = 0; i < v.length; ++i) {
                        list[i] = v[i].getString();
                    }
                    throw new RepositoryException("Index already exists, but is not just one property, but " + Arrays.toString(list));
                }
                if (!this.propertyName.equals(v[0].getString())) {
                    throw new RepositoryException("Index already exists, but is for property " + v[0].getString());
                }
                if (index.hasProperty("declaringNodeTypes")) {
                    v = index.getProperty("declaringNodeTypes").getValues();
                    Object[] list = new String[v.length];
                    for (int i = 0; i < v.length; ++i) {
                        list[i] = v[i].getString();
                    }
                    Arrays.sort(list);
                    if (Arrays.equals(list, this.nodeTypeNames)) {
                        throw new RepositoryException("Index already exists, but with different node types: " + Arrays.toString(list));
                    }
                } else if (this.nodeTypeNames != null) {
                    throw new RepositoryException("Index already exists, but without node type restriction");
                }
                return index;
            }
            Node index = indexDef.addNode(this.indexName, "oak:QueryIndexDefinition");
            index.setProperty("type", indexType);
            index.setProperty("reindex", true);
            index.setProperty("propertyNames", new String[]{this.propertyName}, 7);
            if (this.nodeTypeNames != null) {
                index.setProperty("declaringNodeTypes", this.nodeTypeNames);
            }
            session.save();
            return index;
        }
    }
}

