/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.benchmark.wikipedia;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.oak.benchmark.Benchmark;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.util.Text;

public class WikipediaImport
extends Benchmark {
    private final File dump;
    private final boolean doReport;
    private final boolean flat;
    private boolean haltImport;

    public WikipediaImport(File dump, boolean flat, boolean doReport) {
        this.dump = dump;
        this.flat = flat;
        this.doReport = doReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Iterable<RepositoryFixture> fixtures) {
        if (this.dump.isFile()) {
            for (RepositoryFixture fixture : fixtures) {
                if (fixture.isAvailable(1)) {
                    System.out.format("%s: Wikipedia import benchmark%n", fixture);
                    try {
                        Repository[] cluster = this.setupCluster(fixture);
                        try {
                            this.run(cluster[0]);
                        }
                        finally {
                            this.tearDown(fixture);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                System.out.format("%s: not available, skipping.%n", fixture);
            }
        } else {
            System.out.format("Missing Wikipedia dump %s, skipping import benchmark.%n", this.dump.getPath());
        }
    }

    protected void tearDown(RepositoryFixture fixture) throws IOException {
        fixture.tearDownCluster();
    }

    protected Repository[] setupCluster(RepositoryFixture fixture) throws Exception {
        return fixture.setUpCluster(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Repository repository) throws Exception {
        Session session = repository.login(new SimpleCredentials("admin", "admin".toCharArray()));
        try {
            int before = this.importWikipedia(session);
            int after = new Traversal().traverse(session);
            Preconditions.checkState(before == after, "Import vs. traverse mismatch");
        }
        finally {
            session.logout();
        }
    }

    public void issueHaltImport() {
        this.haltImport = true;
    }

    public int importWikipedia(Session session) throws Exception {
        StreamSource source;
        long start = System.currentTimeMillis();
        int count = 0;
        int code = 0;
        if (this.doReport) {
            System.out.format("Importing %s...%n", this.dump);
        }
        String type = "nt:unstructured";
        if (session.getWorkspace().getNodeTypeManager().hasNodeType("oak:Unstructured")) {
            type = "oak:Unstructured";
        }
        Node wikipedia = session.getRootNode().addNode("wikipedia", type);
        int levels = 0;
        if (!this.flat) {
            for (long pages = this.dump.length() / 1024L; pages > 256L; pages /= 256L) {
                ++levels;
            }
        }
        String title = null;
        String text = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        if (this.dump.getName().endsWith(".xml")) {
            source = new StreamSource(this.dump);
        } else {
            CompressorStreamFactory csf = new CompressorStreamFactory();
            source = new StreamSource(csf.createCompressorInputStream(new BufferedInputStream(new FileInputStream(this.dump))));
        }
        this.haltImport = false;
        XMLStreamReader reader = factory.createXMLStreamReader(source);
        while (reader.hasNext() && !this.haltImport) {
            switch (reader.next()) {
                case 1: {
                    if ("title".equals(reader.getLocalName())) {
                        title = reader.getElementText();
                        break;
                    }
                    if (!"text".equals(reader.getLocalName())) break;
                    text = reader.getElementText();
                    break;
                }
                case 2: {
                    if (!"page".equals(reader.getLocalName())) break;
                    String name = Text.escapeIllegalJcrChars(title);
                    Node parent = wikipedia;
                    if (levels > 0) {
                        int n = name.length();
                        for (int i = 0; i < levels; ++i) {
                            int hash = name.substring(Math.min(i, n)).hashCode();
                            parent = JcrUtils.getOrAddNode(parent, String.format("%02x", hash & 0xFF));
                        }
                    }
                    Node page = parent.addNode(name);
                    page.setProperty("title", title);
                    page.setProperty("text", text);
                    code += title.hashCode();
                    code += text.hashCode();
                    if (++count % 1000 == 0) {
                        this.batchDone(session, start, count);
                    }
                    this.pageAdded(title, text);
                }
            }
        }
        session.save();
        if (this.doReport) {
            long millis = System.currentTimeMillis() - start;
            System.out.format("Imported %d pages in %d seconds (%.2fms/page)%n", count, millis / 1000L, (double)millis / (double)count);
        }
        return code;
    }

    protected void batchDone(Session session, long start, int count) throws RepositoryException {
        if (!this.flat) {
            session.save();
        }
        if (this.doReport) {
            long millis = System.currentTimeMillis() - start;
            System.out.format("Added %d pages in %d seconds (%.2fms/page)%n", count, millis / 1000L, (double)millis / (double)count);
        }
    }

    protected void pageAdded(String title, String text) {
    }

    private class Traversal {
        private final long start = System.currentTimeMillis();
        private int count = 0;
        private int code = 0;

        private Traversal() {
        }

        private int traverse(Session session) throws Exception {
            System.out.format("Traversing imported pages...%n", new Object[0]);
            Node wikipedia = session.getNode("/wikipedia");
            this.traverse(wikipedia);
            if (WikipediaImport.this.doReport) {
                long millis = System.currentTimeMillis() - this.start;
                System.out.format("Traversed %d pages in %d seconds (%.2fms/page)%n", this.count, millis / 1000L, (double)millis / (double)this.count);
            }
            return this.code;
        }

        private void traverse(Node parent) throws RepositoryException {
            NodeIterator pages = parent.getNodes();
            while (pages.hasNext()) {
                Node page = pages.nextNode();
                this.code += page.getProperty("title").getString().hashCode();
                this.code += page.getProperty("text").getString().hashCode();
                ++this.count;
                if (this.count % 1000 == 0 && WikipediaImport.this.doReport) {
                    long millis = System.currentTimeMillis() - this.start;
                    System.out.format("Read %d pages in %d seconds (%.2fms/page)%n", this.count, millis / 1000L, (double)millis / (double)this.count);
                }
                this.traverse(page);
            }
        }
    }
}

