/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.checkpoint;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.document.CheckpointsHelper;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public abstract class Checkpoints {
    public static Checkpoints onTarMK(FileStore store) {
        return new TarMKCheckpoints(store);
    }

    public static Checkpoints onDocumentMK(DocumentNodeStore store) {
        return new DocumentMKCheckpoints(store);
    }

    public abstract List<CP> list();

    public abstract long removeAll();

    public abstract long removeUnreferenced();

    public abstract int remove(String var1);

    @CheckForNull
    private static String getReferenceCheckpoint(NodeState root) {
        String ref = null;
        PropertyState refPS = root.getChildNode(":async").getProperty("async");
        if (refPS != null) {
            ref = refPS.getValue(Type.STRING);
        }
        if (ref != null) {
            System.out.println("Referenced checkpoint from /:async@async is " + ref);
        }
        return ref;
    }

    public static final class CP {
        public final String id;
        public final long created;
        public final long expires;

        private CP(String id, long created, long expires) {
            this.id = id;
            this.created = created;
            this.expires = expires;
        }
    }

    private static final class DocumentMKCheckpoints
    extends Checkpoints {
        private final DocumentNodeStore store;

        private DocumentMKCheckpoints(DocumentNodeStore store) {
            this.store = store;
        }

        @Override
        public List<CP> list() {
            ArrayList<CP> list = Lists.newArrayList();
            for (Map.Entry<Revision, Long> entry : CheckpointsHelper.getCheckpoints(this.store).entrySet()) {
                list.add(new CP(entry.getKey().toString(), entry.getKey().getTimestamp(), entry.getValue()));
            }
            return list;
        }

        @Override
        public long removeAll() {
            return CheckpointsHelper.removeAll(this.store);
        }

        @Override
        public long removeUnreferenced() {
            String ref = Checkpoints.getReferenceCheckpoint(this.store.getRoot());
            if (ref == null) {
                return -1L;
            }
            return CheckpointsHelper.removeOlderThan(this.store, Revision.fromString(ref));
        }

        @Override
        public int remove(String cp) {
            Revision r;
            try {
                r = Revision.fromString(cp);
            }
            catch (IllegalArgumentException e) {
                return 0;
            }
            return CheckpointsHelper.remove(this.store, r);
        }
    }

    private static final class TarMKCheckpoints
    extends Checkpoints {
        private final FileStore store;

        public TarMKCheckpoints(FileStore store) {
            this.store = store;
        }

        @Override
        public List<CP> list() {
            ArrayList<CP> list = Lists.newArrayList();
            NodeState ns = this.store.getHead().getChildNode("checkpoints");
            for (ChildNodeEntry childNodeEntry : ns.getChildNodeEntries()) {
                NodeState cneNs = childNodeEntry.getNodeState();
                list.add(new CP(childNodeEntry.getName(), cneNs.getLong("created"), cneNs.getLong("timestamp")));
            }
            return list;
        }

        @Override
        public long removeAll() {
            SegmentNodeState head = this.store.getHead();
            SegmentNodeBuilder builder = head.builder();
            NodeBuilder cps = builder.getChildNode("checkpoints");
            long cnt = cps.getChildNodeCount(Integer.MAX_VALUE);
            builder.setChildNode("checkpoints");
            if (this.store.setHead(head, TarMKCheckpoints.asSegmentNodeState(builder))) {
                return cnt;
            }
            return -1L;
        }

        @Override
        public long removeUnreferenced() {
            SegmentNodeState head = this.store.getHead();
            String ref = Checkpoints.getReferenceCheckpoint(head.getChildNode("root"));
            SegmentNodeBuilder builder = head.builder();
            NodeBuilder cps = builder.getChildNode("checkpoints");
            long cnt = 0L;
            for (String c : cps.getChildNodeNames()) {
                if (c.equals(ref)) continue;
                cps.getChildNode(c).remove();
                ++cnt;
            }
            if (this.store.setHead(head, TarMKCheckpoints.asSegmentNodeState(builder))) {
                return cnt;
            }
            return -1L;
        }

        @Override
        public int remove(String cp) {
            SegmentNodeState head = this.store.getHead();
            SegmentNodeBuilder builder = head.builder();
            NodeBuilder cpn = builder.getChildNode("checkpoints").getChildNode(cp);
            if (cpn.exists()) {
                cpn.remove();
                if (this.store.setHead(head, TarMKCheckpoints.asSegmentNodeState(builder))) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        private static SegmentNodeState asSegmentNodeState(NodeBuilder builder) {
            return (SegmentNodeState)builder.getNodeState();
        }
    }
}

