/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.console;

import com.mongodb.MongoClientURI;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.apache.jackrabbit.oak.console.ConsoleSession;
import org.apache.jackrabbit.oak.console.GroovyConsole;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDataSourceFactory;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.codehaus.groovy.tools.shell.IO;

public class Console {
    public static void main(String[] args) throws Exception {
        NodeStoreFixture fixture;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<Integer> clusterId = parser.accepts("clusterId", "MongoMK clusterId").withRequiredArg().ofType(Integer.class).defaultsTo(0, (Integer[])new Integer[0]);
        OptionSpecBuilder quiet = parser.accepts("quiet", "be less chatty");
        OptionSpecBuilder shell = parser.accepts("shell", "run the shell after executing files");
        AbstractOptionSpec help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "show help").forHelp();
        ArgumentAcceptingOptionSpec<String> rdbjdbcuser = parser.accepts("rdbjdbcuser", "RDB JDBC user").withOptionalArg().defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbcpasswd = parser.accepts("rdbjdbcpasswd", "RDB JDBC password").withOptionalArg().defaultsTo("", (String[])new String[0]);
        NonOptionArgumentSpec<String> nonOption = parser.nonOptions("console {<path-to-repository> | <mongodb-uri>}");
        OptionSet options = parser.parse(args);
        List nonOptions = nonOption.values(options);
        if (options.has(help)) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        if (nonOptions.isEmpty()) {
            parser.printHelpOn(System.err);
            System.exit(1);
        }
        if (((String)nonOptions.get(0)).startsWith("mongodb://")) {
            MongoClientURI uri = new MongoClientURI((String)nonOptions.get(0));
            if (uri.getDatabase() == null) {
                System.err.println("Database missing in MongoDB URI: " + uri.getURI());
                System.exit(1);
            }
            MongoConnection mongo = new MongoConnection(uri.getURI());
            DocumentNodeStore store = new DocumentMK.Builder().setMongoDB(mongo.getDB()).setClusterId((Integer)clusterId.value(options)).getNodeStore();
            fixture = new MongoFixture(store);
        } else if (((String)nonOptions.get(0)).startsWith("jdbc")) {
            DataSource ds = RDBDataSourceFactory.forJdbcUrl((String)nonOptions.get(0), (String)rdbjdbcuser.value(options), (String)rdbjdbcpasswd.value(options));
            DocumentNodeStore store = new DocumentMK.Builder().setRDBConnection(ds).setClusterId((Integer)clusterId.value(options)).getNodeStore();
            fixture = new MongoFixture(store);
        } else {
            fixture = new SegmentFixture(new FileStore(new File((String)nonOptions.get(0)), 256));
        }
        List<String> scriptArgs = nonOptions.size() > 1 ? nonOptions.subList(1, nonOptions.size()) : Collections.emptyList();
        IO io = new IO();
        if (options.has(quiet)) {
            io.setVerbosity(IO.Verbosity.QUIET);
        }
        GroovyConsole console = new GroovyConsole(ConsoleSession.create(fixture.getStore()), new IO(), fixture);
        int code = 0;
        if (!scriptArgs.isEmpty()) {
            code = console.execute(scriptArgs);
        }
        if (scriptArgs.isEmpty() || options.has(shell)) {
            code = console.run();
        }
        System.exit(code);
    }

    private static class SegmentFixture
    implements NodeStoreFixture {
        private final SegmentStore segmentStore;
        private final SegmentNodeStore nodeStore;

        private SegmentFixture(SegmentStore segmentStore) {
            this.segmentStore = segmentStore;
            this.nodeStore = new SegmentNodeStore(segmentStore);
        }

        @Override
        public NodeStore getStore() {
            return this.nodeStore;
        }

        @Override
        public void close() throws IOException {
            this.segmentStore.close();
        }
    }

    private static class MongoFixture
    implements NodeStoreFixture {
        private final DocumentNodeStore nodeStore;

        private MongoFixture(DocumentNodeStore nodeStore) {
            this.nodeStore = nodeStore;
        }

        @Override
        public NodeStore getStore() {
            return this.nodeStore;
        }

        @Override
        public void close() throws IOException {
            this.nodeStore.dispose();
        }
    }

    private static interface NodeStoreFixture
    extends Closeable {
        public NodeStore getStore();
    }
}

