/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.console;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public abstract class ConsoleSession {
    private final Map<String, Object> context = Maps.newHashMap();
    private final NodeStore store;

    private ConsoleSession(NodeStore store) {
        this.store = store;
    }

    public static ConsoleSession create(NodeStore store) {
        return new DefaultSession(store);
    }

    public String getWorkingPath() {
        String path = (String)this.context.get("workingPath");
        if (path == null) {
            path = "/";
            this.context.put("workingPath", path);
        }
        return path;
    }

    public String setWorkingPath(String path) {
        String old = this.getWorkingPath();
        this.context.put("workingPath", path);
        return old;
    }

    public String checkpoint(long lifetimeSeconds) {
        return this.store.checkpoint(TimeUnit.SECONDS.toMillis(lifetimeSeconds));
    }

    public void retrieve(String checkpoint) {
        this.context.put("root", this.store.retrieve(checkpoint));
    }

    public NodeState getRoot() {
        NodeState root = (NodeState)this.context.get("root");
        if (root == null || this.isAutoRefresh()) {
            root = this.store.getRoot();
            this.context.put("root", root);
        }
        return root;
    }

    public NodeStore getStore() {
        return this.store;
    }

    @Nonnull
    public NodeState getWorkingNode() {
        NodeState current = this.getRoot();
        for (String element : PathUtils.elements(this.getWorkingPath())) {
            current = current.getChildNode(element);
        }
        return current;
    }

    public void setAutoRefresh(boolean enable) {
        if (enable) {
            this.context.put("auto-refresh", "true");
        } else {
            this.context.remove("auto-refresh");
        }
    }

    public boolean isAutoRefresh() {
        return this.context.containsKey("auto-refresh");
    }

    public void refresh() {
        this.context.put("root", this.store.getRoot());
    }

    private static final class DefaultSession
    extends ConsoleSession {
        DefaultSession(NodeStore store) {
            super(store);
        }
    }
}

