/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.console.commands;

import com.google.common.collect.Sets;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MetaClass;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jline.console.completer.Completer;
import jline.console.history.FileHistory;
import org.apache.jackrabbit.oak.console.ConsoleSession;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.tools.shell.BufferManager;
import org.codehaus.groovy.tools.shell.CommandSupport;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintDocumentCommand
extends CommandSupport {
    public static final String COMMAND_NAME = "print-document";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1457347020421;
    private static /* synthetic */ SoftReference $callSiteArray;

    public PrintDocumentCommand(Groovysh shell) {
        super(shell, COMMAND_NAME, "pd");
    }

    @Override
    public Object execute(List<String> args) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            ConsoleSession consoleSession = this.getSession();
            valueRecorder.record(consoleSession, -1);
            valueRecorder.record(consoleSession, -1);
            valueRecorder.record(consoleSession, 8);
            NodeStore nodeStore = consoleSession.getStore();
            valueRecorder.record(nodeStore, -1);
            valueRecorder.record(nodeStore, 16);
            boolean bl = nodeStore instanceof DocumentNodeStore;
            valueRecorder.record(bl, 22);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed(AssertionRenderer.render("assert session.store instanceof DocumentNodeStore", valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        String id = Utils.getIdFromPath(this.getSession().getWorkingPath());
        NodeDocument doc = (NodeDocument)ScriptBytecodeAdapter.castToType(this.getStore().getDocumentStore().find(Collection.NODES, id), NodeDocument.class);
        if (doc == null) {
            this.io.out.println("[null]");
        } else {
            this.println(doc, this.io.out);
        }
        return null;
    }

    public ConsoleSession getSession() {
        return (ConsoleSession)ScriptBytecodeAdapter.castToType(this.getVariables().get("session"), ConsoleSession.class);
    }

    public DocumentNodeStore getStore() {
        return (DocumentNodeStore)ScriptBytecodeAdapter.castToType(this.getSession().getStore(), DocumentNodeStore.class);
    }

    private void println(NodeDocument doc, PrintWriter writer) throws IOException {
        int level = 1;
        HashSet<String> mapKeys = Sets.newHashSet();
        writer.write("{");
        String comma = "";
        String key = null;
        Iterator<String> iterator = doc.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            key = ShortTypeHandling.castToString(iterator.next());
            Object value = doc.get(key);
            if (value instanceof Map) {
                mapKeys.add(key);
                continue;
            }
            writer.write(comma);
            comma = string = ",";
            writer.println();
            PrintDocumentCommand.printIndent(level, writer);
            PrintDocumentCommand.printJson(key, value, writer);
        }
        String key2 = null;
        Iterator iterator2 = mapKeys.iterator();
        while (iterator2.hasNext()) {
            String string;
            key2 = ShortTypeHandling.castToString(iterator2.next());
            writer.write(comma);
            comma = string = ",";
            writer.println();
            PrintDocumentCommand.printIndent(level, writer);
            writer.write(JSONObject.escape(key2));
            writer.write(": {");
            this.println((Map)ScriptBytecodeAdapter.castToType(doc.get(key2), Map.class), level + 1, writer);
            writer.println();
            PrintDocumentCommand.printIndent(level, writer);
            writer.write("}");
        }
        writer.println();
        writer.write("}");
        writer.println();
        writer.flush();
    }

    private void println(Map map, int level, Writer writer) throws IOException {
        String comma = "";
        Object obj2 = null;
        for (Object obj2 : map.keySet()) {
            String string;
            String key = DefaultGroovyMethods.toString(obj2);
            Object value = map.get(obj2);
            writer.write(comma);
            comma = string = ",";
            DefaultGroovyMethods.println(writer);
            PrintDocumentCommand.printIndent(level, writer);
            PrintDocumentCommand.printJson(key, value, writer);
        }
    }

    private static void printJson(String key, Object value, Writer writer) throws IOException {
        writer.write(JSONObject.escape(key));
        writer.write(": ");
        writer.write(PrintDocumentCommand.jsonEscape(value));
    }

    private static String jsonEscape(Object value) {
        String escaped = JSONValue.toJSONString(value);
        return escaped.replaceAll("\\\\/", "/");
    }

    private static void printIndent(int level, Writer writer) throws IOException {
        writer.write(StringGroovyMethods.multiply(" ", (Number)(level * 4)));
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PrintDocumentCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, PrintDocumentCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(PrintDocumentCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PrintDocumentCommand.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        PrintDocumentCommand.__$swapInit();
        Long l = 0L;
        __timeStamp__239_neverHappen1457347020421 = l;
        Long l2 = 1457347020421L;
        __timeStamp = l2;
    }

    public /* synthetic */ void this$3$println(NodeDocument nodeDocument, PrintWriter printWriter) {
        this.println(nodeDocument, printWriter);
    }

    public /* synthetic */ void this$3$println(Map map, int n, Writer writer) {
        this.println(map, n, writer);
    }

    @Override
    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$2$setProperty(String string, Object object) {
        super.setProperty(string, object);
    }

    public /* synthetic */ BufferManager super$2$getBuffers() {
        return super.getBuffers();
    }

    public /* synthetic */ String super$2$getHelp() {
        return super.getHelp();
    }

    public /* synthetic */ Object super$2$this$dist$invoke$1(String string, Object object) {
        return super.this$dist$invoke$1(string, object);
    }

    public /* synthetic */ List super$2$createCompleters() {
        return super.createCompleters();
    }

    @Override
    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ MetaClass super$2$getMetaClass() {
        return super.getMetaClass();
    }

    public /* synthetic */ void super$2$setMetaClass(MetaClass metaClass) {
        super.setMetaClass(metaClass);
    }

    public /* synthetic */ Map super$2$getVariables() {
        return super.getVariables();
    }

    public /* synthetic */ List super$2$getBuffer() {
        return super.getBuffer();
    }

    public /* synthetic */ String super$2$getDescription() {
        return super.getDescription();
    }

    public /* synthetic */ String super$2$getShortcut() {
        return super.getShortcut();
    }

    public /* synthetic */ void super$2$this$dist$set$1(String string, Object object) {
        super.this$dist$set$1(string, object);
    }

    public /* synthetic */ Object super$2$invokeMethod(String string, Object object) {
        return super.invokeMethod(string, object);
    }

    public /* synthetic */ Object super$2$getProperty(String string) {
        return super.getProperty(string);
    }

    public /* synthetic */ String super$2$getName() {
        return super.getName();
    }

    public /* synthetic */ void super$2$fail(String string, Throwable throwable) {
        super.fail(string, throwable);
    }

    public /* synthetic */ void super$2$fail(String string) {
        super.fail(string);
    }

    public /* synthetic */ void super$2$assertNoArguments(List list) {
        super.assertNoArguments(list);
    }

    public /* synthetic */ void super$2$alias(String string, String string2) {
        super.alias(string, string2);
    }

    public /* synthetic */ void super$2$setHidden(boolean bl) {
        super.setHidden(bl);
    }

    @Override
    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Completer super$2$getCompleter() {
        return super.getCompleter();
    }

    public /* synthetic */ String super$2$getUsage() {
        return super.getUsage();
    }

    public /* synthetic */ GroovyClassLoader super$2$getClassLoader() {
        return super.getClassLoader();
    }

    public /* synthetic */ boolean super$2$isHidden() {
        return super.isHidden();
    }

    public /* synthetic */ boolean super$2$getHidden() {
        return super.getHidden();
    }

    public /* synthetic */ Object super$2$this$dist$get$1(String string) {
        return super.this$dist$get$1(string);
    }

    public /* synthetic */ Binding super$2$getBinding() {
        return super.getBinding();
    }

    public /* synthetic */ List super$2$getImports() {
        return super.getImports();
    }

    public /* synthetic */ List super$2$getAliases() {
        return super.getAliases();
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ FileHistory super$2$getHistory() {
        return super.getHistory();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(PrintDocumentCommand.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PrintDocumentCommand.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

