/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.core.MutableRoot;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContext;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContentSessionImpl
implements ContentSession {
    private static final Logger log = LoggerFactory.getLogger(ContentSessionImpl.class);
    private static final AtomicLong SESSION_COUNTER = new AtomicLong();
    private final LoginContext loginContext;
    private final SecurityProvider securityProvider;
    private final String workspaceName;
    private final NodeStore store;
    private final CommitHook hook;
    private final QueryEngineSettings queryEngineSettings;
    private final QueryIndexProvider indexProvider;
    private final String sessionName;
    private boolean live = true;

    public ContentSessionImpl(@Nonnull LoginContext loginContext, @Nonnull SecurityProvider securityProvider, @Nonnull String workspaceName, @Nonnull NodeStore store, @Nonnull CommitHook hook, QueryEngineSettings queryEngineSettings, @Nonnull QueryIndexProvider indexProvider) {
        this.loginContext = loginContext;
        this.securityProvider = securityProvider;
        this.workspaceName = workspaceName;
        this.store = store;
        this.hook = hook;
        this.queryEngineSettings = queryEngineSettings;
        this.indexProvider = indexProvider;
        this.sessionName = "session-" + SESSION_COUNTER.incrementAndGet();
    }

    synchronized void checkLive() {
        Preconditions.checkState(this.live, "This session has been closed");
    }

    @Override
    @Nonnull
    public AuthInfo getAuthInfo() {
        this.checkLive();
        return AuthInfoImpl.createFromSubject(this.loginContext.getSubject());
    }

    @Override
    public String getWorkspaceName() {
        return this.workspaceName;
    }

    @Override
    @Nonnull
    public Root getLatestRoot() {
        this.checkLive();
        return new MutableRoot(this.store, this.hook, this.workspaceName, this.loginContext.getSubject(), this.securityProvider, this.queryEngineSettings, this.indexProvider, this);
    }

    @Override
    public synchronized void close() throws IOException {
        this.live = false;
        try {
            this.loginContext.logout();
        }
        catch (LoginException e) {
            log.error("Error during logout.", e);
        }
    }

    public String toString() {
        return this.sessionName;
    }
}

