/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class SecureNodeState
extends AbstractNodeState {
    private final NodeState state;
    private final TreePermission treePermission;
    private long childNodeCount = -1L;
    private long propertyCount = -1L;

    SecureNodeState(@Nonnull NodeState state, @Nonnull TreePermission treePermission) {
        this.state = Preconditions.checkNotNull(state);
        this.treePermission = Preconditions.checkNotNull(treePermission);
    }

    @Override
    public boolean exists() {
        return this.treePermission.canRead();
    }

    @Override
    @CheckForNull
    public PropertyState getProperty(@Nonnull String name) {
        PropertyState property = this.state.getProperty(name);
        if (property != null && this.treePermission.canRead(property)) {
            return property;
        }
        return null;
    }

    @Override
    public synchronized long getPropertyCount() {
        if (this.propertyCount == -1L) {
            this.propertyCount = this.treePermission.canReadProperties() ? this.state.getPropertyCount() : SecureNodeState.count(Iterables.filter(this.state.getProperties(), new ReadablePropertyPredicate()));
        }
        return this.propertyCount;
    }

    @Override
    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        if (this.treePermission.canReadProperties()) {
            return this.state.getProperties();
        }
        return Iterables.filter(this.state.getProperties(), new ReadablePropertyPredicate());
    }

    @Override
    public boolean hasChildNode(@Nonnull String name) {
        if (!this.state.hasChildNode(name)) {
            return false;
        }
        if (this.treePermission.canReadAll()) {
            return true;
        }
        NodeState child = this.state.getChildNode(name);
        return this.treePermission.getChildPermission(name, child).canRead();
    }

    @Override
    @Nonnull
    public NodeState getChildNode(@Nonnull String name) {
        NodeState child = this.state.getChildNode(name);
        if (child.exists() && !this.treePermission.canReadAll()) {
            MemoryChildNodeEntry entry = new MemoryChildNodeEntry(name, child);
            return new WrapChildEntryFunction().apply(entry).getNodeState();
        }
        return child;
    }

    @Override
    public synchronized long getChildNodeCount(long max) {
        if (this.childNodeCount == -1L) {
            long count = this.treePermission.canReadAll() ? this.state.getChildNodeCount(max) : super.getChildNodeCount(max);
            if (count == Long.MAX_VALUE) {
                return count;
            }
            this.childNodeCount = count;
        }
        return this.childNodeCount;
    }

    @Override
    @Nonnull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        if (this.treePermission.canReadAll()) {
            return this.state.getChildNodeEntries();
        }
        if (this.treePermission.canRead()) {
            Iterable<ChildNodeEntry> readable = Iterables.transform(this.state.getChildNodeEntries(), new WrapChildEntryFunction());
            return Iterables.filter(readable, new IterableNodePredicate());
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public NodeBuilder builder() {
        return new MemoryNodeBuilder(this);
    }

    private class WrapChildEntryFunction
    implements Function<ChildNodeEntry, ChildNodeEntry> {
        private WrapChildEntryFunction() {
        }

        @Override
        @Nonnull
        public ChildNodeEntry apply(@Nonnull ChildNodeEntry input) {
            String name = input.getName();
            NodeState child = input.getNodeState();
            TreePermission childContext = SecureNodeState.this.treePermission.getChildPermission(name, child);
            SecureNodeState secureChild = new SecureNodeState(child, childContext);
            if (child.getChildNodeCount(1L) == 0L && secureChild.treePermission.canRead() && secureChild.treePermission.canReadProperties()) {
                return input;
            }
            return new MemoryChildNodeEntry(name, secureChild);
        }
    }

    private static class IterableNodePredicate
    implements Predicate<ChildNodeEntry> {
        private IterableNodePredicate() {
        }

        @Override
        public boolean apply(@Nullable ChildNodeEntry input) {
            return input != null && input.getNodeState().exists();
        }
    }

    private class ReadablePropertyPredicate
    implements Predicate<PropertyState> {
        private ReadablePropertyPredicate() {
        }

        @Override
        public boolean apply(@Nullable PropertyState property) {
            return property != null && SecureNodeState.this.treePermission.canRead(property);
        }
    }
}

