/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.explorer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.explorer.NodeStoreTree;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;

public class Explorer {
    private static String skip = "skip-size-check";

    public static void main(String[] args) throws IOException {
        new Explorer(args);
    }

    public Explorer(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("usage: explore <path> [skip-size-check]");
            System.exit(1);
        }
        final File path = new File(args[0]);
        final boolean skipSizeCheck = args.length == 2 && skip.equalsIgnoreCase(args[1]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Explorer.initLF();
                try {
                    Explorer.this.createAndShowGUI(path, skipSizeCheck);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static void initLF() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createAndShowGUI(final File path, boolean skipSizeCheck) throws IOException {
        JTextArea log = new JTextArea(5, 20);
        log.setMargin(new Insets(5, 5, 5, 5));
        log.setLineWrap(true);
        log.setEditable(false);
        final NodeStoreTree treePanel = new NodeStoreTree(path, log, skipSizeCheck);
        final JFrame frame = new JFrame("Explore " + path + " @head");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                IOUtils.closeQuietly(treePanel);
                System.exit(0);
            }
        });
        JPanel content = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(treePanel), new JScrollPane(log));
        splitPane.setDividerLocation(0.3);
        content.add((Component)new JScrollPane(splitPane), c);
        frame.getContentPane().add(content);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setMargin(new Insets(2, 2, 2, 2));
        JMenuItem menuReopen = new JMenuItem("Reopen");
        menuReopen.setMnemonic(82);
        menuReopen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    treePanel.reopen();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        JMenuItem menuCompaction = new JMenuItem("Time Machine");
        menuCompaction.setMnemonic(84);
        menuCompaction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                List<String> revs = FileStoreHelper.readRevisions(path);
                String s = (String)JOptionPane.showInputDialog(frame, "Revert to a specified revision", "Time Machine", -1, null, revs.toArray(), revs.get(0));
                if (s != null && treePanel.revert(s)) {
                    frame.setTitle("Explore " + path + " @" + s);
                }
            }
        });
        JMenuItem menuRefs = new JMenuItem("Tar File Info");
        menuRefs.setMnemonic(73);
        menuRefs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ArrayList<String> tarFiles = new ArrayList<String>();
                for (File f : path.listFiles()) {
                    if (!f.getName().endsWith(".tar")) continue;
                    tarFiles.add(f.getName());
                }
                String s = (String)JOptionPane.showInputDialog(frame, "Choose a tar file", "Tar File Info", -1, null, tarFiles.toArray(), tarFiles.get(0));
                if (s != null) {
                    treePanel.printTarInfo(s);
                    return;
                }
            }
        });
        JMenuItem menuSCR = new JMenuItem("Segment Refs");
        menuSCR.setMnemonic(82);
        menuSCR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String s = JOptionPane.showInputDialog(frame, "Segment References\nUsage: <segmentId>", "Segment References", -1);
                if (s != null) {
                    treePanel.printSegmentReferences(s);
                    return;
                }
            }
        });
        JMenuItem menuDiff = new JMenuItem("SegmentNodeState diff");
        menuDiff.setMnemonic(68);
        menuDiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String s = JOptionPane.showInputDialog(frame, "SegmentNodeState diff\nUsage: <recordId> <recordId> [<path>]", "SegmentNodeState diff", -1);
                if (s != null) {
                    treePanel.printDiff(s);
                    return;
                }
            }
        });
        JMenuItem menuPCM = new JMenuItem("Persisted Compaction Maps");
        menuPCM.setMnemonic(80);
        menuPCM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                treePanel.printPCMInfo();
            }
        });
        menuBar.add(menuReopen);
        menuBar.add(new JSeparator(1));
        menuBar.add(menuCompaction);
        menuBar.add(new JSeparator(1));
        menuBar.add(menuRefs);
        menuBar.add(new JSeparator(1));
        menuBar.add(menuSCR);
        menuBar.add(new JSeparator(1));
        menuBar.add(menuDiff);
        menuBar.add(new JSeparator(1));
        menuBar.add(menuPCM);
        menuBar.add(new JSeparator(1));
        frame.setJMenuBar(menuBar);
        frame.pack();
        frame.setSize(960, 720);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

