/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.explorer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.escape.Escapers;
import java.awt.GridLayout;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.PCMAnalyser;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlob;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStateHelper;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.plugins.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class NodeStoreTree
extends JPanel
implements TreeSelectionListener,
Closeable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_CHAR_DISPLAY = Integer.getInteger("max.char.display", 60);
    private final File path;
    private FileStore.ReadOnlyStore store;
    private Map<String, Set<UUID>> index;
    private DefaultTreeModel treeModel;
    private final JTree tree;
    private final JTextArea log;
    private Map<RecordIdKey, Long[]> sizeCache;
    private final boolean skipSizeCheck;

    public NodeStoreTree(File path, JTextArea log, boolean skipSizeCheck) throws IOException {
        super(new GridLayout(1, 0));
        this.path = path;
        this.log = log;
        this.skipSizeCheck = skipSizeCheck;
        this.tree = new JTree();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this);
        this.tree.setExpandsSelectedPaths(true);
        this.refreshStore();
        this.refreshModel();
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.add(scrollPane);
    }

    private void refreshStore() throws IOException {
        this.store = new FileStore.ReadOnlyStore(this.path);
    }

    private void refreshModel() {
        this.index = this.store.getTarReaderIndex();
        this.sizeCache = Maps.newHashMap();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(new NamePathModel("/", "/", this.store.getHead(), this.sizeCache, this.skipSizeCheck, this.store), true);
        this.treeModel = new DefaultTreeModel(rootNode);
        this.addChildren(rootNode);
        this.tree.setModel(this.treeModel);
    }

    public void reopen() throws IOException {
        this.close();
        this.refreshStore();
        this.refreshModel();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            this.addChildren(node);
            this.updateStats(node);
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
            StringBuilder sb = new StringBuilder();
            sb.append(ex.getMessage());
            sb.append("\n");
            NamePathModel model = (NamePathModel)node.getUserObject();
            NodeState state = model.getState();
            if (state instanceof SegmentNodeState) {
                SegmentNodeState sns = (SegmentNodeState)state;
                sb.append("Record ");
                sb.append(sns.getRecordId().toString());
                sb.append("\n");
            }
            this.setText(sb.toString());
        }
    }

    private void setText(String s) {
        this.log.setText(s);
        this.log.setCaretPosition(0);
    }

    private void addChildren(DefaultMutableTreeNode parent) {
        NamePathModel model = (NamePathModel)parent.getUserObject();
        if (model.isLoaded()) {
            return;
        }
        ArrayList<NamePathModel> kids = Lists.newArrayList();
        for (ChildNodeEntry childNodeEntry : model.getState().getChildNodeEntries()) {
            NamePathModel c = new NamePathModel(childNodeEntry.getName(), PathUtils.concat(model.getPath(), childNodeEntry.getName()), childNodeEntry.getNodeState(), this.sizeCache, this.skipSizeCheck, this.store);
            kids.add(c);
        }
        Collections.sort(kids);
        for (NamePathModel namePathModel : kids) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(namePathModel, true);
            this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        }
        model.loaded();
    }

    private void updateStats(DefaultMutableTreeNode parent) {
        NamePathModel model = (NamePathModel)parent.getUserObject();
        StringBuilder sb = new StringBuilder();
        sb.append(model.getPath());
        sb.append("\n");
        NodeState state = model.getState();
        String tarFile = "";
        if (state instanceof SegmentNodeState) {
            SegmentNodeState s = (SegmentNodeState)state;
            RecordId recordId = s.getRecordId();
            sb.append("Record " + recordId);
            tarFile = this.getFile(recordId);
            if (tarFile.length() > 0) {
                sb.append(" in " + tarFile);
            }
            sb.append("\n");
            RecordId recordId2 = SegmentNodeStateHelper.getTemplateId(s);
            String string = this.getFile(recordId2);
            sb.append("TemplateId ");
            sb.append(recordId2);
            if (!string.equals(tarFile)) {
                sb.append(" in " + string);
            }
            sb.append("\n");
        }
        sb.append("Size: ");
        sb.append("  direct: ");
        sb.append(FileUtils.byteCountToDisplaySize(model.getSize()[0]));
        sb.append(";  linked: ");
        sb.append(FileUtils.byteCountToDisplaySize(model.getSize()[1]));
        sb.append("\n");
        sb.append("Properties (count: " + state.getPropertyCount() + ")");
        sb.append("\n");
        TreeMap<String, String> propLines = Maps.newTreeMap();
        for (PropertyState propertyState : state.getProperties()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  - " + propertyState.getName() + " = {" + propertyState.getType() + "} ");
            if (propertyState.getType().isArray()) {
                int count = propertyState.count();
                stringBuilder.append("(count " + count + ") [");
                String separator = ", ";
                int max = 50;
                if (propertyState.getType() == Type.BINARIES) {
                    separator = "\n      ";
                    max = Integer.MAX_VALUE;
                    stringBuilder.append(separator);
                }
                for (int i = 0; i < Math.min(count, max); ++i) {
                    if (i > 0) {
                        stringBuilder.append(separator);
                    }
                    stringBuilder.append(this.toString(propertyState, i, tarFile));
                }
                if (count > max) {
                    stringBuilder.append(", ... (" + count + " values)");
                }
                if (propertyState.getType() == Type.BINARIES) {
                    stringBuilder.append(separator);
                }
                stringBuilder.append("]");
            } else {
                stringBuilder.append(this.toString(propertyState, 0, tarFile));
            }
            if (propertyState instanceof SegmentPropertyState) {
                RecordId rid = ((SegmentPropertyState)propertyState).getRecordId();
                stringBuilder.append(" (" + rid);
                String f = this.getFile(rid);
                if (!f.equals(tarFile)) {
                    stringBuilder.append(" in " + f);
                }
                stringBuilder.append(")");
            } else {
                stringBuilder.append(" (" + propertyState.getClass().getSimpleName() + ")");
            }
            propLines.put(propertyState.getName(), stringBuilder.toString());
        }
        for (String string : propLines.values()) {
            sb.append(string);
            sb.append("\n");
        }
        sb.append("Child nodes (count: " + state.getChildNodeCount(Long.MAX_VALUE) + ")");
        sb.append("\n");
        TreeMap<String, String> childLines = Maps.newTreeMap();
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            StringBuilder l = new StringBuilder();
            l.append("  + " + childNodeEntry.getName());
            NodeState c = childNodeEntry.getNodeState();
            if (c instanceof SegmentNodeState) {
                RecordId rid = ((SegmentNodeState)c).getRecordId();
                l.append(" (" + rid);
                String f = this.getFile(rid);
                if (!f.equals(tarFile)) {
                    l.append(" in " + f);
                }
                l.append(")");
            } else {
                l.append(" (" + c.getClass().getSimpleName() + ")");
            }
            childLines.put(childNodeEntry.getName(), l.toString());
        }
        for (String string : childLines.values()) {
            sb.append(string);
            sb.append("\n");
        }
        if ("/".equals(model.getPath())) {
            sb.append("File Reader Index");
            sb.append("\n");
            for (String string : FileStoreHelper.getTarFiles(this.store)) {
                sb.append(string);
                sb.append("\n");
            }
            sb.append("----------");
        }
        this.setText(sb.toString());
    }

    private String toString(PropertyState ps, int index, String tarFile) {
        if (ps.getType().tag() == 2) {
            Blob b = ps.getValue(Type.BINARY, index);
            String info = "<";
            info = info + b.getClass().getSimpleName() + ";";
            info = info + "ref:" + this.safeGetReference(b) + ";";
            info = info + "id:" + b.getContentIdentity() + ";";
            info = info + this.safeGetLength(b) + ">";
            for (SegmentId sid : SegmentBlob.getBulkSegmentIds(b)) {
                info = info + "\n        Bulk Segment Id " + sid;
                String f = this.getFile(sid);
                if (f.equals(tarFile)) continue;
                info = info + " in " + f;
            }
            return info;
        }
        if (ps.getType().tag() == 1) {
            return NodeStoreTree.displayString(ps.getValue(Type.STRING, index));
        }
        return ps.getValue(Type.STRING, index);
    }

    private static String displayString(String value) {
        if (MAX_CHAR_DISPLAY > 0 && value.length() > MAX_CHAR_DISPLAY) {
            value = value.substring(0, MAX_CHAR_DISPLAY) + "... (" + value.length() + " chars)";
        }
        String escaped = Escapers.builder().setSafeRange(' ', '~').addEscape('\"', "\\\"").addEscape('\\', "\\\\").build().escape(value);
        return '\"' + escaped + '\"';
    }

    private String safeGetReference(Blob b) {
        try {
            return b.getReference();
        }
        catch (IllegalStateException illegalStateException) {
            return "[BlobStore not available]";
        }
    }

    private String safeGetLength(Blob b) {
        try {
            return FileUtils.byteCountToDisplaySize(b.length());
        }
        catch (IllegalStateException illegalStateException) {
            return "[BlobStore not available]";
        }
    }

    private String getFile(RecordId id) {
        return this.getFile(id.getSegmentId());
    }

    private String getFile(SegmentId segmentId) {
        for (Map.Entry<String, Set<UUID>> path2Uuid : this.index.entrySet()) {
            for (UUID uuid : path2Uuid.getValue()) {
                if (!uuid.equals(segmentId.asUUID())) continue;
                return new File(path2Uuid.getKey()).getName();
            }
        }
        return "";
    }

    public void printTarInfo(String file) {
        Sets.SetView<UUID> inMem;
        if (file == null || file.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Set<UUID> uuids = Sets.newHashSet();
        for (Map.Entry<String, Set<UUID>> e : this.index.entrySet()) {
            if (!e.getKey().endsWith(file)) continue;
            sb.append("SegmentNodeState references to " + new File(e.getKey()).getName());
            sb.append("\n");
            uuids = e.getValue();
            break;
        }
        if (!(inMem = Sets.intersection(NodeStoreTree.getReferencedUUIDs(this.store), uuids)).isEmpty()) {
            sb.append("In Memory segment references: ");
            sb.append("\n");
            sb.append(inMem);
            sb.append("\n");
        }
        ArrayList<String> paths = Lists.newArrayList();
        NodeStoreTree.filterNodeStates(uuids, paths, this.store.getHead(), "/");
        if (!paths.isEmpty()) {
            sb.append("Repository content references:");
            sb.append("\n");
            for (String p : paths) {
                sb.append(p);
                sb.append("\n");
            }
        }
        sb.append("\n");
        try {
            Map<UUID, List<UUID>> graph = this.store.getTarGraph(file);
            sb.append("Tar graph:").append("\n");
            for (Map.Entry<UUID, List<UUID>> entry : graph.entrySet()) {
                sb.append(entry.getKey()).append('=').append(entry.getValue()).append("\n");
            }
            sb.append("\n");
        }
        catch (IOException e) {
            sb.append("Error getting tar graph:").append(e).append("\n");
        }
        this.setText(sb.toString());
    }

    private static Set<UUID> getReferencedUUIDs(FileStore store) {
        HashSet<UUID> ids = Sets.newHashSet();
        for (SegmentId id : store.getTracker().getReferencedSegmentIds()) {
            ids.add(id.asUUID());
        }
        return ids;
    }

    public void printSegmentReferences(String sid) {
        if (sid == null || sid.length() == 0) {
            return;
        }
        UUID id = null;
        try {
            id = UUID.fromString(sid.trim());
        }
        catch (IllegalArgumentException e) {
            this.setText(e.getMessage());
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("References to segment " + id);
        sb.append("\n");
        for (Map.Entry<String, Set<UUID>> e : this.index.entrySet()) {
            if (!e.getValue().contains(id)) continue;
            sb.append("Tar file: " + new File(e.getKey()).getName());
            sb.append("\n");
            break;
        }
        ArrayList<String> paths = Lists.newArrayList();
        NodeStoreTree.filterNodeStates(Sets.newHashSet(id), paths, this.store.getHead(), "/");
        if (!paths.isEmpty()) {
            sb.append("Repository content references:");
            sb.append("\n");
            for (String p : paths) {
                sb.append(p);
                sb.append("\n");
            }
        }
        HashMap<UUID, Set<Map.Entry<UUID, String>>> links = Maps.newHashMap();
        try {
            FileStoreHelper.getGcRoots(this.store, id, links);
        }
        catch (IOException e) {
            sb.append("\n");
            sb.append(e.getMessage());
        }
        if (!links.isEmpty()) {
            sb.append("Segment GC roots:");
            sb.append("\n");
            FileStoreHelper.printGcRoots(sb, links, id, "  ", "  ");
        }
        this.setText(sb.toString());
    }

    public static void filterNodeStates(Set<UUID> uuids, List<String> paths, SegmentNodeState state, String path) {
        RecordId templateId;
        TreeSet<String> localPaths = Sets.newTreeSet();
        for (PropertyState ps : state.getProperties()) {
            if (!(ps instanceof SegmentPropertyState)) continue;
            SegmentPropertyState sps = (SegmentPropertyState)ps;
            RecordId recordId = sps.getRecordId();
            UUID id = recordId.getSegmentId().asUUID();
            if (uuids.contains(id)) {
                if (ps.getType().tag() == 1) {
                    String val = "";
                    if (ps.count() > 0) {
                        val = NodeStoreTree.displayString(ps.getValue(Type.STRING, 0));
                    }
                    localPaths.add(path + ps.getName() + " = " + val + " [SegmentPropertyState<" + ps.getType() + ">@" + recordId + "]");
                } else {
                    localPaths.add(path + ps + " [SegmentPropertyState<" + ps.getType() + ">@" + recordId + "]");
                }
            }
            if (ps.getType().tag() != 2) continue;
            for (int i = 0; i < ps.count(); ++i) {
                Blob b = ps.getValue(Type.BINARY, i);
                for (SegmentId sbid : SegmentBlob.getBulkSegmentIds(b)) {
                    UUID bid = sbid.asUUID();
                    if (bid.equals(id) || !uuids.contains(bid)) continue;
                    localPaths.add(path + ps + " [SegmentPropertyState<" + ps.getType() + ">@" + recordId + "]");
                }
            }
        }
        RecordId stateId = state.getRecordId();
        if (uuids.contains(stateId.getSegmentId().asUUID())) {
            localPaths.add(path + " [SegmentNodeState@" + stateId + "]");
        }
        if (uuids.contains((templateId = SegmentNodeStateHelper.getTemplateId(state)).getSegmentId().asUUID())) {
            localPaths.add(path + "[Template@" + templateId + "]");
        }
        paths.addAll(localPaths);
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            NodeState c = childNodeEntry.getNodeState();
            if (!(c instanceof SegmentNodeState)) continue;
            NodeStoreTree.filterNodeStates(uuids, paths, (SegmentNodeState)c, path + childNodeEntry.getName() + "/");
        }
    }

    public void printDiff(String input) {
        StringBuilder sb = new StringBuilder();
        if (input == null || input.trim().length() == 0) {
            sb.append("Unknown argument: ");
            sb.append(input);
            sb.append("\n");
            this.setText("Usage <recordId> <recordId> [<path>]");
            return;
        }
        String[] tokens = input.trim().split(" ");
        if (tokens.length != 2 && tokens.length != 3) {
            sb.append("Unknown argument: ");
            sb.append(input);
            sb.append("\n");
            this.setText("Usage <recordId> <recordId> [<path>]");
            return;
        }
        RecordId id1 = null;
        RecordId id2 = null;
        try {
            id1 = RecordId.fromString(this.store.getTracker(), tokens[0]);
            id2 = RecordId.fromString(this.store.getTracker(), tokens[1]);
        }
        catch (IllegalArgumentException ex) {
            sb.append("Unknown argument: ");
            sb.append(input);
            sb.append("\n");
            sb.append("Error: ");
            sb.append(ex.getMessage());
            sb.append("\n");
            this.setText(sb.toString());
            return;
        }
        String path = "/";
        if (tokens.length == 3) {
            path = tokens[2];
        }
        NodeState node1 = new SegmentNodeState(id1);
        NodeState node2 = new SegmentNodeState(id2);
        for (String name : PathUtils.elements(path)) {
            node1 = node1.getChildNode(name);
            node2 = node2.getChildNode(name);
        }
        sb.append("SegmentNodeState diff ");
        sb.append(id1);
        sb.append(" vs ");
        sb.append(id2);
        sb.append(" at ");
        sb.append(path);
        sb.append("\n");
        sb.append("--------");
        sb.append("\n");
        sb.append(JsopBuilder.prettyPrint(JsopDiff.diffToJsop(node1, node2)));
        this.setText(sb.toString());
    }

    public boolean revert(String revision) {
        return this.safeRevert(revision, false);
    }

    private boolean safeRevert(String revision, boolean rollback) {
        String head = this.store.getHead().getRecordId().toString();
        this.store.setRevision(revision);
        try {
            this.refreshModel();
            if (!rollback) {
                this.setText("Switched head revision to " + revision);
            }
        }
        catch (SegmentNotFoundException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to switch head revision to ");
            sb.append(revision);
            sb.append("\n");
            sb.append("    ");
            sb.append(e.getMessage());
            sb.append("\n");
            sb.append("Will rollback to ");
            sb.append(head);
            this.setText(sb.toString());
            return this.safeRevert(head, true);
        }
        return !rollback;
    }

    public void printPCMInfo() {
        this.setText(new PCMAnalyser(this.store).toString());
    }

    private static Long[] exploreSize(SegmentNodeState ns, Map<RecordIdKey, Long[]> sizeCache) {
        RecordIdKey key = new RecordIdKey(ns.getRecordId());
        if (sizeCache.containsKey(key)) {
            return sizeCache.get(key);
        }
        Long[] s = new Long[]{0L, 0L};
        ArrayList<String> names = Lists.newArrayList(ns.getChildNodeNames());
        if (names.contains("root")) {
            ArrayList<String> temp = Lists.newArrayList();
            int poz = 0;
            for (String n : names) {
                if (n.equals("root")) {
                    temp.add(poz, n);
                    ++poz;
                    continue;
                }
                temp.add(n);
            }
            names = temp;
        }
        for (String n : names) {
            Long[] ks;
            SegmentNodeState k = (SegmentNodeState)ns.getChildNode(n);
            RecordIdKey ckey = new RecordIdKey(k.getRecordId());
            if (sizeCache.containsKey(ckey)) {
                ks = sizeCache.get(ckey);
                s[1] = s[1] + ks[0] + ks[1];
                continue;
            }
            ks = NodeStoreTree.exploreSize(k, sizeCache);
            s[0] = s[0] + ks[0];
            s[1] = s[1] + ks[1];
        }
        for (PropertyState ps : ns.getProperties()) {
            for (int j = 0; j < ps.count(); ++j) {
                if (ps.getType().tag() == Type.BINARY.tag()) {
                    boolean skip;
                    Blob b = ps.getValue(Type.BINARY, j);
                    boolean bl = skip = b instanceof SegmentBlob && ((SegmentBlob)b).isExternal();
                    if (skip) continue;
                    s[0] = s[0] + b.length();
                    continue;
                }
                s[0] = s[0] + ps.size(j);
            }
        }
        sizeCache.put(key, s);
        return s;
    }

    @Override
    public void close() throws IOException {
        this.store.close();
    }

    private static class RecordIdKey {
        private final long msb;
        private final long lsb;
        private final int offset;

        public RecordIdKey(RecordId rid) {
            this.offset = rid.getOffset();
            this.msb = rid.getSegmentId().getMostSignificantBits();
            this.lsb = rid.getSegmentId().getLeastSignificantBits();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof RecordIdKey) {
                RecordIdKey that = (RecordIdKey)object;
                return this.offset == that.offset && this.msb == that.msb && this.lsb == that.lsb;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.lsb ^ this.offset;
        }
    }

    private static class NamePathModel
    implements Comparable<NamePathModel> {
        private final FileStore store;
        private final String name;
        private final String path;
        private final boolean skipSizeCheck;
        private boolean loaded = false;
        private Long[] size = new Long[]{-1L, -1L};

        public NamePathModel(String name, String path, NodeState state, Map<RecordIdKey, Long[]> sizeCache, boolean skipSizeCheck, FileStore store) {
            this.store = store;
            this.name = name;
            this.path = path;
            this.skipSizeCheck = skipSizeCheck;
            if (!skipSizeCheck && state instanceof SegmentNodeState) {
                this.size = NodeStoreTree.exploreSize((SegmentNodeState)state, sizeCache);
            }
        }

        public void loaded() {
            this.loaded = true;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public String toString() {
            if (this.skipSizeCheck) {
                return this.name;
            }
            if (this.size[1] > 0L) {
                return this.name + " (" + FileUtils.byteCountToDisplaySize(this.size[0]) + ";" + FileUtils.byteCountToDisplaySize(this.size[1]) + ")";
            }
            if (this.size[0] > 0L) {
                return this.name + " (" + FileUtils.byteCountToDisplaySize(this.size[0]) + ")";
            }
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public NodeState getState() {
            return this.loadState();
        }

        private NodeState loadState() {
            NodeState n = this.store.getHead();
            for (String p : PathUtils.elements(this.path)) {
                n = n.getChildNode(p);
            }
            return n;
        }

        @Override
        public int compareTo(NamePathModel o) {
            int s = this.size[0].compareTo(o.size[0]);
            if (s != 0) {
                return -1 * s;
            }
            s = this.size[1].compareTo(o.size[1]);
            if (s != 0) {
                return -1 * s;
            }
            if ("root".equals(this.name)) {
                return 1;
            }
            if ("root".equals(o.name)) {
                return -1;
            }
            return this.name.compareTo(o.name);
        }

        public Long[] getSize() {
            return this.size;
        }
    }
}

