/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.fixture;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.FileBlobStore;
import org.apache.jackrabbit.oak.spi.blob.MemoryBlobStore;

public abstract class BlobStoreFixture
implements Closeable {
    private final String name;
    protected final String unique;

    public BlobStoreFixture(String name) {
        this.name = name;
        this.unique = BlobStoreFixture.getUniqueName(name);
    }

    public abstract BlobStore setUp();

    public abstract void tearDown();

    public abstract long size();

    @Override
    public void close() {
        this.tearDown();
    }

    @CheckForNull
    public static BlobStoreFixture create(File basedir, boolean fallbackToFDS) {
        String blobStore;
        String className = System.getProperty("dataStore");
        if (className != null) {
            return BlobStoreFixture.getDataStore();
        }
        if (basedir == null) {
            basedir = FileUtils.getTempDirectory();
        }
        if ("FDS".equals(blobStore = System.getProperty("blobStoreType")) || blobStore == null && fallbackToFDS) {
            return BlobStoreFixture.getFileDataStore(basedir, 16);
        }
        if ("FBS".equals(blobStore)) {
            return BlobStoreFixture.getFileBlobStore(basedir);
        }
        if ("MEM".equals(blobStore)) {
            return BlobStoreFixture.getMemoryBlobStore();
        }
        return null;
    }

    public static BlobStoreFixture getFileDataStore(final File basedir, final int fdsCacheInMB) {
        return new BlobStoreFixture("FDS"){
            private File storeDir;
            private FileDataStore fds;

            @Override
            public BlobStore setUp() {
                this.fds = new FileDataStore();
                this.fds.setMinRecordLength(4092);
                this.storeDir = new File(basedir, this.unique);
                this.fds.init(this.storeDir.getAbsolutePath());
                BlobStoreFixture.configure(this.fds);
                DataStoreBlobStore bs = new DataStoreBlobStore(this.fds, true, fdsCacheInMB);
                BlobStoreFixture.configure(bs);
                return bs;
            }

            @Override
            public void tearDown() {
                this.fds.close();
                FileUtils.deleteQuietly(this.storeDir);
            }

            @Override
            public long size() {
                return FileUtils.sizeOfDirectory(this.storeDir);
            }
        };
    }

    public static BlobStoreFixture getFileBlobStore(final File basedir) {
        return new BlobStoreFixture("FBS"){
            private File storeDir;
            private FileBlobStore fbs;

            @Override
            public BlobStore setUp() {
                this.storeDir = new File(basedir, this.unique);
                this.fbs = new FileBlobStore(this.storeDir.getAbsolutePath());
                BlobStoreFixture.configure(this.fbs);
                return this.fbs;
            }

            @Override
            public void tearDown() {
                FileUtils.deleteQuietly(this.storeDir);
            }

            @Override
            public long size() {
                return FileUtils.sizeOfDirectory(this.storeDir);
            }
        };
    }

    public static BlobStoreFixture getMemoryBlobStore() {
        return new BlobStoreFixture("MEM"){
            private MemoryBlobStore mbs = new MemoryBlobStore();

            @Override
            public BlobStore setUp() {
                return this.mbs;
            }

            @Override
            public void tearDown() {
            }

            @Override
            public long size() {
                throw new UnsupportedOperationException("Implementation pending");
            }
        };
    }

    public static BlobStoreFixture getDataStore() {
        return new BlobStoreFixture("DS"){
            private DataStore dataStore;
            private BlobStore blobStore;

            @Override
            public BlobStore setUp() {
                String className = System.getProperty("dataStore");
                Preconditions.checkNotNull(className, "No system property named 'dataStore' defined");
                try {
                    this.dataStore = Class.forName(className).asSubclass(DataStore.class).newInstance();
                    BlobStoreFixture.configure(this.dataStore);
                    this.dataStore.init(null);
                    this.blobStore = new DataStoreBlobStore(this.dataStore);
                    BlobStoreFixture.configure(this.blobStore);
                    return this.blobStore;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot instantiate DataStore " + className, e);
                }
            }

            @Override
            public void tearDown() {
                if (this.blobStore instanceof DataStoreBlobStore) {
                    ((DataStoreBlobStore)this.blobStore).clearInUse();
                    try {
                        ((DataStoreBlobStore)this.blobStore).deleteAllOlderThan(System.currentTimeMillis() + 10000000L);
                    }
                    catch (DataStoreException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            public long size() {
                throw new UnsupportedOperationException("Implementation pending");
            }
        };
    }

    private static String getUniqueName(String name) {
        return String.format("%s-%d", name, System.currentTimeMillis());
    }

    private static void configure(Object o) {
        PropertiesUtil.populate(o, BlobStoreFixture.getConfig(), false);
    }

    private static Map<String, ?> getConfig() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry e : Maps.fromProperties(System.getProperties()).entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith("ds.") && !key.startsWith("bs.")) continue;
            key = key.substring(3);
            result.put(key, e.getValue());
        }
        return result;
    }
}

