/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.fixture;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.fixture.BlobStoreFixture;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDataSourceFactory;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public abstract class OakFixture {
    public static final String OAK_MEMORY = "Oak-Memory";
    public static final String OAK_MEMORY_NS = "Oak-MemoryNS";
    public static final String OAK_MONGO = "Oak-Mongo";
    public static final String OAK_MONGO_FDS = "Oak-Mongo-FDS";
    public static final String OAK_MONGO_NS = "Oak-MongoNS";
    public static final String OAK_RDB = "Oak-RDB";
    public static final String OAK_RDB_FDS = "Oak-RDB-FDS";
    public static final String OAK_TAR = "Oak-Tar";
    public static final String OAK_TAR_FDS = "Oak-Tar-FDS";
    private final String name;
    protected final String unique;

    protected OakFixture(String name) {
        this.name = name;
        this.unique = OakFixture.getUniqueDatabaseName(name);
    }

    public static String getUniqueDatabaseName(String name) {
        return String.format("%s-%d", name, System.currentTimeMillis());
    }

    public abstract Oak getOak(int var1) throws Exception;

    public abstract Oak[] setUpCluster(int var1) throws Exception;

    public abstract void tearDownCluster();

    public String toString() {
        return this.name;
    }

    public static OakFixture getMemory(long cacheSize) {
        return OakFixture.getMemory(OAK_MEMORY, cacheSize);
    }

    public static OakFixture getMemoryNS(long cacheSize) {
        return OakFixture.getMemory(OAK_MEMORY_NS, cacheSize);
    }

    public static OakFixture getMemory(String name, long cacheSize) {
        return new OakFixture(name){

            @Override
            public Oak getOak(int clusterId) throws Exception {
                Oak oak = OakFixture.newOak(new MemoryNodeStore());
                return oak;
            }

            @Override
            public Oak[] setUpCluster(int n) throws Exception {
                Oak[] cluster = new Oak[n];
                for (int i = 0; i < cluster.length; ++i) {
                    Oak oak;
                    cluster[i] = oak = OakFixture.newOak(new MemoryNodeStore());
                }
                return cluster;
            }

            @Override
            public void tearDownCluster() {
            }
        };
    }

    public static OakFixture getMongo(String uri, boolean dropDBAfterTest, long cacheSize) {
        return OakFixture.getMongo(OAK_MONGO, uri, dropDBAfterTest, cacheSize, false, null, 0);
    }

    public static OakFixture getMongo(String host, int port, String database, boolean dropDBAfterTest, long cacheSize) {
        return OakFixture.getMongo(OAK_MONGO, host, port, database, dropDBAfterTest, cacheSize, false, null, 0);
    }

    public static OakFixture getMongoNS(String uri, boolean dropDBAfterTest, long cacheSize) {
        return OakFixture.getMongo(OAK_MONGO_NS, uri, dropDBAfterTest, cacheSize, false, null, 0);
    }

    public static OakFixture getMongoNS(String host, int port, String database, boolean dropDBAfterTest, long cacheSize) {
        return OakFixture.getMongo(OAK_MONGO_NS, host, port, database, dropDBAfterTest, cacheSize, false, null, 0);
    }

    public static OakFixture getMongo(String name, String host, int port, String database, boolean dropDBAfterTest, long cacheSize, boolean useFileDataStore, File base, int fdsCacheInMB) {
        if (database == null) {
            database = OakFixture.getUniqueDatabaseName(name);
        }
        String uri = "mongodb://" + host + ":" + port + "/" + database;
        return OakFixture.getMongo(name, uri, dropDBAfterTest, cacheSize, useFileDataStore, base, fdsCacheInMB);
    }

    public static OakFixture getMongo(String name, final String uri, final boolean dropDBAfterTest, final long cacheSize, final boolean useFileDataStore, final File base, final int fdsCacheInMB) {
        return new OakFixture(name){
            private DocumentMK[] kernels;
            private BlobStoreFixture blobStoreFixture;
            {
                super(x0);
                this.blobStoreFixture = useFileDataStore ? BlobStoreFixture.getFileDataStore(base, fdsCacheInMB) : BlobStoreFixture.create(base, false);
            }

            @Override
            public Oak getOak(int clusterId) throws Exception {
                MongoConnection mongo = new MongoConnection(uri);
                DocumentMK.Builder mkBuilder = new DocumentMK.Builder().setMongoDB(mongo.getDB()).memoryCacheSize(cacheSize).setPersistentCache("target/persistentCache,time").setClusterId(clusterId).setLogging(false);
                this.setupBlobStore(mkBuilder);
                DocumentMK dmk = mkBuilder.open();
                return OakFixture.newOak(dmk.getNodeStore());
            }

            @Override
            public Oak[] setUpCluster(int n) throws Exception {
                Oak[] cluster = new Oak[n];
                this.kernels = new DocumentMK[cluster.length];
                for (int i = 0; i < cluster.length; ++i) {
                    MongoConnection mongo = new MongoConnection(uri);
                    DocumentMK.Builder mkBuilder = new DocumentMK.Builder().setMongoDB(mongo.getDB()).memoryCacheSize(cacheSize).setPersistentCache("target/persistentCache,time").setClusterId(i + 1).setLogging(false);
                    this.setupBlobStore(mkBuilder);
                    this.kernels[i] = mkBuilder.open();
                    cluster[i] = OakFixture.newOak(this.kernels[i].getNodeStore());
                }
                return cluster;
            }

            @Override
            public void tearDownCluster() {
                for (DocumentMK kernel : this.kernels) {
                    kernel.dispose();
                }
                if (dropDBAfterTest) {
                    try {
                        MongoConnection mongo = new MongoConnection(uri);
                        mongo.getDB().dropDatabase();
                        mongo.close();
                        if (this.blobStoreFixture != null) {
                            this.blobStoreFixture.tearDown();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            private void setupBlobStore(DocumentMK.Builder mkBuilder) {
                if (this.blobStoreFixture != null) {
                    mkBuilder.setBlobStore(this.blobStoreFixture.setUp());
                }
            }
        };
    }

    public static OakFixture getRDB(String name, String jdbcuri, String jdbcuser, String jdbcpasswd, String tablePrefix, boolean dropDBAfterTest, long cacheSize) {
        return OakFixture.getRDB(name, jdbcuri, jdbcuser, jdbcpasswd, tablePrefix, dropDBAfterTest, cacheSize, false, null, 0);
    }

    public static OakFixture getRDB(String name, final String jdbcuri, final String jdbcuser, final String jdbcpasswd, final String tablePrefix, final boolean dropDBAfterTest, final long cacheSize, final boolean useFileDataStore, final File base, final int fdsCacheInMB) {
        return new OakFixture(name){
            private DocumentMK[] kernels;
            private BlobStoreFixture blobStoreFixture;
            {
                super(x0);
                if (useFileDataStore) {
                    this.blobStoreFixture = BlobStoreFixture.getFileDataStore(base, fdsCacheInMB);
                }
            }

            private RDBOptions getOptions(boolean dropDBAFterTest, String tablePrefix2) {
                return new RDBOptions().dropTablesOnClose(dropDBAfterTest).tablePrefix(tablePrefix2);
            }

            private BlobStore getBlobStore() {
                try {
                    if (useFileDataStore) {
                        return this.blobStoreFixture.setUp();
                    }
                    DataSource ds = RDBDataSourceFactory.forJdbcUrl(jdbcuri, jdbcuser, jdbcpasswd);
                    return new RDBBlobStore(ds, this.getOptions(dropDBAfterTest, tablePrefix));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Oak getOak(int clusterId) throws Exception {
                DataSource ds = RDBDataSourceFactory.forJdbcUrl(jdbcuri, jdbcuser, jdbcpasswd);
                DocumentMK.Builder mkBuilder = new DocumentMK.Builder().setRDBConnection(ds, this.getOptions(dropDBAfterTest, tablePrefix)).memoryCacheSize(cacheSize).setClusterId(clusterId).setLogging(false);
                BlobStore blobStore = this.getBlobStore();
                if (blobStore != null) {
                    mkBuilder.setBlobStore(blobStore);
                }
                DocumentMK dmk = mkBuilder.open();
                return OakFixture.newOak(dmk.getNodeStore());
            }

            @Override
            public Oak[] setUpCluster(int n) throws Exception {
                Oak[] cluster = new Oak[n];
                this.kernels = new DocumentMK[cluster.length];
                for (int i = 0; i < cluster.length; ++i) {
                    BlobStore blobStore = this.getBlobStore();
                    DataSource ds = RDBDataSourceFactory.forJdbcUrl(jdbcuri, jdbcuser, jdbcpasswd);
                    DocumentMK.Builder mkBuilder = new DocumentMK.Builder().setRDBConnection(ds, this.getOptions(dropDBAfterTest, tablePrefix)).memoryCacheSize(cacheSize).setLeaseCheck(false).setClusterId(i + 1).setLogging(false);
                    if (blobStore != null) {
                        mkBuilder.setBlobStore(blobStore);
                    }
                    this.kernels[i] = mkBuilder.open();
                    cluster[i] = OakFixture.newOak(this.kernels[i].getNodeStore());
                }
                return cluster;
            }

            @Override
            public void tearDownCluster() {
                String dropped = "";
                for (DocumentMK kernel : this.kernels) {
                    kernel.dispose();
                    if (!(kernel.getDocumentStore() instanceof RDBDocumentStore)) continue;
                    dropped = dropped + ((RDBDocumentStore)kernel.getDocumentStore()).getDroppedTables();
                }
                if (dropDBAfterTest) {
                    if (this.blobStoreFixture != null) {
                        this.blobStoreFixture.tearDown();
                    }
                    if (dropped.isEmpty()) {
                        throw new RuntimeException("dropdb was set, but tables have not been dropped");
                    }
                }
            }
        };
    }

    public static OakFixture getTar(String name, File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping, boolean useBlobStore) {
        return new SegmentFixture(name, base, maxFileSizeMB, cacheSizeMB, memoryMapping, useBlobStore);
    }

    private static Oak newOak(NodeStore nodeStore) {
        return new Oak(nodeStore).with(ManagementFactory.getPlatformMBeanServer());
    }

    public static class SegmentFixture
    extends OakFixture {
        private FileStore[] stores;
        private BlobStoreFixture[] blobStoreFixtures = new BlobStoreFixture[0];
        private final File base;
        private final int maxFileSizeMB;
        private final int cacheSizeMB;
        private final boolean memoryMapping;
        private final boolean useBlobStore;

        public SegmentFixture(String name, File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping, boolean useBlobStore) {
            super(name);
            this.base = base;
            this.maxFileSizeMB = maxFileSizeMB;
            this.cacheSizeMB = cacheSizeMB;
            this.memoryMapping = memoryMapping;
            this.useBlobStore = useBlobStore;
        }

        @Override
        public Oak getOak(int clusterId) throws Exception {
            FileStore fs = new FileStore(this.base, this.maxFileSizeMB, this.cacheSizeMB, this.memoryMapping);
            return OakFixture.newOak(new SegmentNodeStore(fs));
        }

        @Override
        public Oak[] setUpCluster(int n) throws Exception {
            Oak[] cluster = new Oak[n];
            this.stores = new FileStore[cluster.length];
            if (this.useBlobStore) {
                this.blobStoreFixtures = new BlobStoreFixture[cluster.length];
            }
            for (int i = 0; i < cluster.length; ++i) {
                BlobStore blobStore = null;
                if (this.useBlobStore) {
                    this.blobStoreFixtures[i] = BlobStoreFixture.create(this.base, true);
                    blobStore = this.blobStoreFixtures[i].setUp();
                }
                this.stores[i] = new FileStore(blobStore, new File(this.base, this.unique), EmptyNodeState.EMPTY_NODE, this.maxFileSizeMB, this.cacheSizeMB, this.memoryMapping);
                cluster[i] = OakFixture.newOak(new SegmentNodeStore(this.stores[i]));
            }
            return cluster;
        }

        @Override
        public void tearDownCluster() {
            for (FileStore store : this.stores) {
                store.close();
            }
            for (BlobStoreFixture blobStore : this.blobStoreFixtures) {
                blobStore.tearDown();
            }
            FileUtils.deleteQuietly(new File(this.base, this.unique));
        }

        public BlobStoreFixture[] getBlobStoreFixtures() {
            return this.blobStoreFixtures;
        }

        public FileStore[] getStores() {
            return this.stores;
        }
    }
}

