/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.fixture;

import java.io.File;
import javax.jcr.Repository;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;

public class OakRepositoryFixture
implements RepositoryFixture {
    private final OakFixture oakFixture;
    private Repository[] cluster;

    public static RepositoryFixture getMemoryNS(long cacheSize) {
        return OakRepositoryFixture.getMemory("Oak-MemoryNS", cacheSize);
    }

    private static RepositoryFixture getMemory(String name, long cacheSize) {
        return new OakRepositoryFixture(OakFixture.getMemory(name, cacheSize));
    }

    public static RepositoryFixture getMongo(String host, int port, String database, boolean dropDBAfterTest, long cacheSize) {
        return OakRepositoryFixture.getMongo("Oak-Mongo", host, port, database, dropDBAfterTest, cacheSize, false, null, 0);
    }

    public static RepositoryFixture getMongo(String uri, boolean dropDBAfterTest, long cacheSize) {
        return OakRepositoryFixture.getMongoNS(uri, dropDBAfterTest, cacheSize);
    }

    public static RepositoryFixture getMongoWithFDS(String host, int port, String database, boolean dropDBAfterTest, long cacheSize, File base, int fdsCacheInMB) {
        return OakRepositoryFixture.getMongo("Oak-Mongo-FDS", host, port, database, dropDBAfterTest, cacheSize, true, base, fdsCacheInMB);
    }

    public static RepositoryFixture getMongoWithFDS(String uri, boolean dropDBAfterTest, long cacheSize, File base, int fdsCacheInMB) {
        return new OakRepositoryFixture(OakFixture.getMongo("Oak-Mongo-FDS", uri, dropDBAfterTest, cacheSize, true, base, fdsCacheInMB));
    }

    public static RepositoryFixture getMongoNS(String host, int port, String database, boolean dropDBAfterTest, long cacheSize) {
        return OakRepositoryFixture.getMongo("Oak-MongoNS", host, port, database, dropDBAfterTest, cacheSize, false, null, 0);
    }

    public static RepositoryFixture getMongoNS(String uri, boolean dropDBAfterTest, long cacheSize) {
        return new OakRepositoryFixture(OakFixture.getMongo(uri, dropDBAfterTest, cacheSize));
    }

    private static RepositoryFixture getMongo(String name, String host, int port, String database, boolean dropDBAfterTest, long cacheSize, boolean useFileDataStore, File base, int fdsCacheInMB) {
        return new OakRepositoryFixture(OakFixture.getMongo(name, host, port, database, dropDBAfterTest, cacheSize, useFileDataStore, base, fdsCacheInMB));
    }

    public static RepositoryFixture getRDB(String jdbcuri, String jdbcuser, String jdbcpasswd, String jdbctableprefix, boolean dropDBAfterTest, long cacheSize) {
        return new OakRepositoryFixture(OakFixture.getRDB("Oak-RDB", jdbcuri, jdbcuser, jdbcpasswd, jdbctableprefix, dropDBAfterTest, cacheSize));
    }

    public static RepositoryFixture getRDBWithFDS(String jdbcuri, String jdbcuser, String jdbcpasswd, String jdbctableprefix, boolean dropDBAfterTest, long cacheSize, File base, int fdsCacheInMB) {
        return new OakRepositoryFixture(OakFixture.getRDB("Oak-RDB-FDS", jdbcuri, jdbcuser, jdbcpasswd, jdbctableprefix, dropDBAfterTest, cacheSize, true, base, fdsCacheInMB));
    }

    public static RepositoryFixture getTar(File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping) {
        return new OakRepositoryFixture(OakFixture.getTar("Oak-Tar", base, maxFileSizeMB, cacheSizeMB, memoryMapping, false));
    }

    public static RepositoryFixture getTarWithBlobStore(File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping) {
        return new OakRepositoryFixture(OakFixture.getTar("Oak-Tar-FDS", base, maxFileSizeMB, cacheSizeMB, memoryMapping, true));
    }

    protected OakRepositoryFixture(OakFixture oakFixture) {
        this.oakFixture = oakFixture;
    }

    @Override
    public boolean isAvailable(int n) {
        return true;
    }

    @Override
    public final Repository[] setUpCluster(int n) throws Exception {
        return this.setUpCluster(n, JcrCreator.DEFAULT);
    }

    public Repository[] setUpCluster(int n, JcrCreator customizer) throws Exception {
        Oak[] oaks = this.oakFixture.setUpCluster(n);
        this.cluster = new Repository[oaks.length];
        for (int i = 0; i < oaks.length; ++i) {
            this.cluster[i] = customizer.customize(oaks[i]).createRepository();
        }
        return this.cluster;
    }

    @Override
    public void syncRepositoryCluster(Repository ... nodes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void tearDownCluster() {
        if (this.cluster != null) {
            for (Repository repo : this.cluster) {
                if (!(repo instanceof JackrabbitRepository)) continue;
                ((JackrabbitRepository)repo).shutdown();
            }
        }
        this.oakFixture.tearDownCluster();
    }

    public String toString() {
        return this.oakFixture.toString();
    }

    public OakFixture getOakFixture() {
        return this.oakFixture;
    }
}

