/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.http;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.http.Representation;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class HtmlRepresentation
implements Representation {
    HtmlRepresentation() {
    }

    @Override
    public MediaType getType() {
        return MediaType.text("html");
    }

    @Override
    public void render(Tree tree, HttpServletResponse response) throws IOException {
        try {
            XHTMLContentHandler xhtml = this.startResponse(response, tree.getPath());
            xhtml.startDocument();
            xhtml.startElement("dl");
            for (PropertyState propertyState : tree.getProperties()) {
                xhtml.element("dt", propertyState.getName());
                if (propertyState.isArray()) {
                    xhtml.startElement("dd");
                    xhtml.startElement("ol");
                    for (String value : propertyState.getValue(Type.STRINGS)) {
                        xhtml.element("li", value);
                    }
                    xhtml.endElement("ol");
                    xhtml.endElement("dd");
                    continue;
                }
                xhtml.element("dd", propertyState.getValue(Type.STRING));
            }
            for (Tree tree2 : tree.getChildren()) {
                String name = tree2.getName();
                xhtml.element("dt", name);
                xhtml.startElement("dd");
                xhtml.startElement("a", "href", response.encodeRedirectURL(URLEncoder.encode(name, Charsets.UTF_8.name()) + "/"));
                xhtml.characters(tree2.getPath());
                xhtml.endElement("a");
                xhtml.endElement("dd");
            }
            xhtml.endElement("dl");
            xhtml.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void render(PropertyState property, HttpServletResponse response) throws IOException {
        try {
            XHTMLContentHandler xhtml = this.startResponse(response, property.getName());
            xhtml.startDocument();
            if (property.isArray()) {
                xhtml.startElement("ol");
                for (String value : property.getValue(Type.STRINGS)) {
                    xhtml.element("li", value);
                }
                xhtml.endElement("ol");
            } else {
                xhtml.element("p", property.getValue(Type.STRING));
            }
            xhtml.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    private XHTMLContentHandler startResponse(HttpServletResponse response, String title) throws IOException {
        try {
            response.setContentType("text/html");
            response.setCharacterEncoding("UTF-8");
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = factory.newTransformerHandler();
            Transformer transformer = handler.getTransformer();
            transformer.setOutputProperty("method", "html");
            transformer.setOutputProperty("encoding", "UTF-8");
            handler.setResult(new StreamResult(response.getOutputStream()));
            Metadata metadata = new Metadata();
            metadata.set("title", title);
            return new XHTMLContentHandler(handler, metadata);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e);
        }
    }
}

