/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.http;

import java.util.HashMap;
import java.util.Map;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;

public class MediaRange {
    private final MediaType type;
    private final double q;

    public static MediaRange parse(String range, MediaTypeRegistry registry) {
        MediaType type = MediaType.parse(range);
        if (type == null) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>((type = registry.normalize(type)).getParameters());
        String q = (String)parameters.remove("q");
        if (q != null) {
            try {
                return new MediaRange(new MediaType(type.getBaseType(), parameters), Double.parseDouble(q));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return new MediaRange(type, 1.0);
    }

    public MediaRange(MediaType type, double q) {
        this.type = type;
        this.q = q;
    }

    public double match(MediaType type, MediaTypeRegistry registry) {
        if (type.equals(this.type)) {
            return this.q;
        }
        for (Map.Entry<String, String> entry : this.type.getParameters().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.equals(type.getParameters().get(key))) continue;
            return 0.0;
        }
        if ("*/*".equals(this.type.toString())) {
            return this.q;
        }
        if ("*".equals(this.type.getSubtype()) && type.getType().equals(this.type.getType())) {
            return this.q;
        }
        return 0.0;
    }
}

