/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.http.Representation;
import org.apache.tika.mime.MediaType;

class PostRepresentation
implements Representation {
    private static final MediaType TYPE = MediaType.parse("application/x-www-form-urlencoded");
    private static final String ENCODING = "UTF-8";

    PostRepresentation() {
    }

    @Override
    public MediaType getType() {
        return TYPE;
    }

    @Override
    public void render(Tree tree, HttpServletResponse response) throws IOException {
        PrintWriter writer = PostRepresentation.startResponse(response);
        boolean first = true;
        for (PropertyState propertyState : tree.getProperties()) {
            String name = propertyState.getName();
            if (propertyState.isArray()) {
                for (String value : propertyState.getValue(Type.STRINGS)) {
                    first = PostRepresentation.render(first, name, value, writer);
                }
                continue;
            }
            first = PostRepresentation.render(first, name, propertyState.getValue(Type.STRING), writer);
        }
    }

    @Override
    public void render(PropertyState property, HttpServletResponse response) throws IOException {
        PrintWriter writer = PostRepresentation.startResponse(response);
        if (property.isArray()) {
            for (String value : property.getValue(Type.STRINGS)) {
                PostRepresentation.render(value, writer);
                writer.print('\n');
            }
        } else {
            PostRepresentation.render(property.getValue(Type.STRING), writer);
        }
    }

    private static PrintWriter startResponse(HttpServletResponse response) throws IOException {
        response.setContentType(TYPE.toString());
        response.setCharacterEncoding(ENCODING);
        return response.getWriter();
    }

    private static boolean render(boolean first, String name, String value, PrintWriter writer) {
        if (!first) {
            writer.print('&');
        }
        PostRepresentation.render(name, writer);
        writer.print('=');
        PostRepresentation.render(value, writer);
        return false;
    }

    private static void render(String string, PrintWriter writer) {
        try {
            writer.print(URLEncoder.encode(string, ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

