/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.http;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.http.Representation;
import org.apache.tika.mime.MediaType;

class TextRepresentation
implements Representation {
    TextRepresentation() {
    }

    @Override
    public MediaType getType() {
        return MediaType.TEXT_PLAIN;
    }

    @Override
    public void render(Tree tree, HttpServletResponse response) throws IOException {
        PrintWriter writer = this.startResponse(response);
        for (PropertyState propertyState : tree.getProperties()) {
            writer.print(propertyState.getName());
            writer.print(": ");
            if (propertyState.isArray()) {
                for (String value : propertyState.getValue(Type.STRINGS)) {
                    writer.print(value);
                    writer.print(", ");
                }
            } else {
                writer.print(propertyState.getValue(Type.STRING));
            }
            writer.print('\n');
        }
        for (Tree tree2 : tree.getChildren()) {
            writer.print(tree2.getName());
            writer.print(": <");
            writer.print(response.encodeRedirectURL(tree2.getName()));
            writer.print(">\n");
        }
    }

    @Override
    public void render(PropertyState property, HttpServletResponse response) throws IOException {
        PrintWriter writer = this.startResponse(response);
        if (property.isArray()) {
            for (String value : property.getValue(Type.STRINGS)) {
                writer.print(value);
                writer.print('\n');
            }
        } else {
            writer.print(property.getValue(Type.STRING));
        }
    }

    private PrintWriter startResponse(HttpServletResponse response) throws IOException {
        response.setContentType(MediaType.TEXT_PLAIN.toString());
        response.setCharacterEncoding("UTF-8");
        return response.getWriter();
    }
}

